/*
 * Decompiled with CFR 0.152.
 */
package _test.sample;

import _test.Meta;
import _test.ResourceCounter;
import _test.io.FileFormatterAssertions;
import _test.io.Util;
import _test.io.text.TextFormatterAssertions;
import _test.sample.Person;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.assertj.core.api.Assertions;

public final class XmlFormatterAssertions {
    public static void assertXmlFormatterCompliance(Path temp, Xml.Formatter<Person> p, boolean formatted) throws IOException {
        TextFormatterAssertions.assertTextFormatterCompliance((Path)temp, p, (Object)Person.JOHN_DOE, encoding -> Person.getString(encoding, formatted), Person.ENCODINGS);
        FileFormatterAssertions.assertFileFormatterCompliance((Path)temp, p, (Object)Person.JOHN_DOE, (byte[])Person.getString(StandardCharsets.UTF_8, formatted).getBytes(StandardCharsets.UTF_8));
    }

    public static void assertFormatterSafety(Path temp, Xml.Formatter<Person> p, Class<? extends Throwable> expectedException) {
        ResourceCounter counter = new ResourceCounter();
        Meta.builder().group("Reader").code().doesNotRaiseExceptionWhen(() -> p.formatWriter((Object)Person.JOHN_DOE, counter.onWriter((IOSupplier<Writer>)((IOSupplier)StringWriter::new)))).exception(IOException.class).as("Null").isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, IOSupplier.of(null))).exception(XmlFormatterTestError.class).as("Throwing").isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, Util.failingSupplier(() -> new XmlFormatterTestError()))).group("Stream").code().doesNotRaiseExceptionWhen(() -> p.formatStream((Object)Person.JOHN_DOE, counter.onOutputStream((IOSupplier<OutputStream>)((IOSupplier)ByteArrayOutputStream::new)))).exception(IOException.class).as("Null").isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, IOSupplier.of(null))).exception(XmlFormatterTestError.class).as("Throwing").isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, Util.failingSupplier(() -> new XmlFormatterTestError()))).group("File").code().doesNotRaiseExceptionWhen(() -> p.formatFile((Object)Person.JOHN_DOE, Files.createTempFile(temp, "a", "b", new FileAttribute[0]).toFile())).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, Files.createTempDirectory(temp, "a", new FileAttribute[0]).toFile())).group("Path").code().doesNotRaiseExceptionWhen(() -> p.formatPath((Object)Person.JOHN_DOE, Files.createTempFile(temp, "a", "b", new FileAttribute[0]))).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, Files.createTempDirectory(temp, "a", new FileAttribute[0]))).group("Chars").code().doesNotRaiseExceptionWhen(() -> p.formatChars((Object)Person.JOHN_DOE, (Appendable)new StringBuilder())).code().doesNotRaiseExceptionWhen(() -> p.formatToString((Object)Person.JOHN_DOE)).build().forEach(callable -> XmlFormatterAssertions.testSafeFormat(counter, expectedException, callable));
    }

    private static void testSafeFormat(ResourceCounter counter, Class<? extends Throwable> expectedException, Meta<IORunnable> callable) {
        counter.reset();
        if (expectedException != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(expectedException);
        } else if (callable.getExpectedException() != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(callable.getExpectedException());
        } else {
            Assertions.assertThatCode(() -> ((IORunnable)callable.getTarget()).runWithIO()).doesNotThrowAnyException();
        }
        Assertions.assertThat((int)counter.getCount()).isLessThanOrEqualTo(0);
    }

    private static final class XmlFormatterTestError
    extends IOException {
        private XmlFormatterTestError() {
        }
    }
}

