/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import internal.io.text.LegacyFiles;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;

public final class Stax {
    private static final Closeable NOTHING_TO_CLOSE = IORunnable.noOp().asCloseable();

    public static void preventXXE(@NonNull XMLInputFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Stax.disableFeature(factory, "javax.xml.stream.supportDTD");
        Stax.disableFeature(factory, "javax.xml.stream.isSupportingExternalEntities");
    }

    @NonNull
    public static IOException toIOException(@NonNull XMLStreamException ex) {
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        return Stax.wrapXMLStreamException(ex);
    }

    private static XMLInputFactory getInputEngine(IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) throws IOException {
        XMLInputFactory result = (XMLInputFactory)factory.getWithIO();
        if (!ignoreXXE) {
            Stax.preventXXE(result);
        }
        return result;
    }

    private static <T, INPUT> T doParse(FlowHandler<INPUT, T> handler, INPUT input, Closeable onClose) throws IOException {
        try {
            return handler.parse(input, onClose);
        }
        catch (XMLStreamException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw Stax.wrapXMLStreamException(ex);
        }
        catch (IOException | Error | RuntimeException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw ex;
        }
    }

    private static <T, OUTPUT> void doFormat(OutputHandler2<OUTPUT, T> handler2, T value, OUTPUT output, Charset encoding, Closeable onClose) throws IOException {
        try {
            handler2.format(value, output, encoding);
        }
        catch (Exception ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw Stax.wrapException(ex);
        }
        catch (Error ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw ex;
        }
    }

    private static Closeable asCloseable(StaxRunnable first) {
        return () -> {
            try {
                first.runWithXMLStream();
            }
            catch (XMLStreamException ex) {
                throw Stax.wrapXMLStreamException(ex);
            }
        };
    }

    private static Closeable asCloseable(StaxRunnable first, Closeable second) {
        return () -> Resource.closeBoth((Closeable)Stax.asCloseable(first), (Closeable)second);
    }

    private static <T, R> IOFunction<T, R> asIOFunction(StaxFunction<T, R> function) {
        return t -> {
            try {
                return function.applyWithXMLStream(t);
            }
            catch (XMLStreamException ex) {
                throw Stax.wrapXMLStreamException(ex);
            }
        };
    }

    private static void disableFeature(XMLInputFactory factory, String feature) {
        if (factory.isPropertySupported(feature) && ((Boolean)factory.getProperty(feature)).booleanValue()) {
            factory.setProperty(feature, false);
        }
    }

    private static IOException wrapException(Exception ex) {
        if (ex instanceof XMLStreamException) {
            return Stax.wrapXMLStreamException((XMLStreamException)ex);
        }
        if (ex instanceof IOException) {
            return (IOException)ex;
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static IOException wrapXMLStreamException(XMLStreamException ex) {
        if (StaxEOF.isEOF(ex)) {
            return new EOFException(Objects.toString(Stax.getFileOrNull(ex)));
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static File getFileOrNull(XMLStreamException ex) {
        Location location = ex.getLocation();
        if (location == null) {
            return null;
        }
        String systemId = location.getSystemId();
        if (systemId == null) {
            return null;
        }
        return LegacyFiles.fromSystemId((String)systemId);
    }

    @Generated
    private Stax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface OutputHandler2<O, T> {
        public void format(@NonNull T var1, @NonNull O var2, @NonNull Charset var3) throws Exception;
    }

    @FunctionalInterface
    private static interface StaxRunnable {
        public void runWithXMLStream() throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface StaxFunction<T, R> {
        public R applyWithXMLStream(T var1) throws XMLStreamException;
    }

    @FunctionalInterface
    public static interface FlowHandler<I, T> {
        @NonNull
        public T parse(@NonNull I var1, @NonNull Closeable var2) throws IOException, XMLStreamException;

        @NonNull
        public static <I, T> FlowHandler<I, T> of(@NonNull ValueHandler<I, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return handler.asFlow();
        }
    }

    private static final class StaxEOF {
        private static final String EOF_MESSAGE_PREFIX = "Message: ";
        private static final ConcurrentMap<Locale, String> EOF_MESSAGE_BY_LOCALE = new ConcurrentHashMap<Locale, String>();

        private StaxEOF() {
        }

        public static boolean isEOF(XMLStreamException ex) {
            return ex.getLocation() != null && StaxEOF.isEOFMessage(ex.getMessage());
        }

        private static boolean isEOFMessage(String message) {
            return message.contains(EOF_MESSAGE_BY_LOCALE.computeIfAbsent(Locale.getDefault(), StaxEOF::loadEOFMessage));
        }

        private static String loadEOFMessage(Locale locale) {
            try {
                StaxEOF.parseEmptyContent(locale);
            }
            catch (XMLStreamException e) {
                return StaxEOF.extractEOFMessage(e);
            }
            return "Premature end of file.";
        }

        private static void parseEmptyContent(Locale ignore) throws XMLStreamException {
            try (XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(""));){
                while (reader.hasNext()) {
                    reader.next();
                }
            }
        }

        private static String extractEOFMessage(XMLStreamException e) {
            String text = e.getMessage();
            int index = text.indexOf(EOF_MESSAGE_PREFIX);
            return index != -1 ? text.substring(index + EOF_MESSAGE_PREFIX.length()) : text;
        }
    }

    public static final class EventFormatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final OutputHandler2<XMLEventWriter, T> handler2;
        @NonNull
        private final IOSupplier<? extends XMLOutputFactory> factory;
        @NonNull
        private final Charset encoding;

        @Deprecated
        @NonNull
        public static <T> EventFormatter<T> valueOf(@NonNull OutputHandler<XMLEventWriter, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return EventFormatter.of(handler.withEncoding());
        }

        @NonNull
        public static <T> EventFormatter<T> of(@NonNull OutputHandler2<XMLEventWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return EventFormatter.builder().handler2(handler2).build();
        }

        @Deprecated
        public EventFormatter<T> withHandler(OutputHandler<XMLEventWriter, T> handler) {
            return this.withHandler2(handler.withEncoding());
        }

        @Override
        public boolean isFormatted() {
            return false;
        }

        @Override
        @NonNull
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (OutputStream resource = LegacyFiles.openOutputStream((File)target);){
                this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(@NonNull T value, @NonNull IOSupplier<? extends Writer> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (Writer resource = LegacyFiles.openWriter(target);){
                this.format(value, o -> o.createXMLEventWriter(resource), this.getDefaultEncoding());
            }
        }

        public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (OutputStream resource = LegacyFiles.openOutputStream(target);){
                this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLEventWriter(resource), this.getDefaultEncoding());
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLEventWriter(resource, encoding.name()), encoding);
        }

        private void format(T value, StaxFunction<XMLOutputFactory, XMLEventWriter> supplier, Charset realEncoding) throws IOException {
            try {
                XMLEventWriter output = supplier.applyWithXMLStream(this.getEngine());
                Stax.doFormat(this.handler2, value, output, realEncoding, Stax.asCloseable(output::close));
                output.close();
            }
            catch (XMLStreamException ex) {
                throw Stax.wrapXMLStreamException(ex);
            }
        }

        private XMLOutputFactory getEngine() throws IOException {
            return (XMLOutputFactory)this.factory.getWithIO();
        }

        @Generated
        private static <T> IOSupplier<? extends XMLOutputFactory> $default$factory() {
            return XMLOutputFactory::newFactory;
        }

        @Generated
        private static <T> Charset $default$encoding() {
            return StandardCharsets.UTF_8;
        }

        @Generated
        EventFormatter(@NonNull OutputHandler2<XMLEventWriter, T> handler2, @NonNull IOSupplier<? extends XMLOutputFactory> factory, @NonNull Charset encoding) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.handler2 = handler2;
            this.factory = factory;
            this.encoding = encoding;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler2(this.handler2).factory(this.factory).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withHandler2(@NonNull OutputHandler2<XMLEventWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return this.handler2 == handler2 ? this : new EventFormatter<T>(handler2, this.factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withFactory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new EventFormatter<T>(this.handler2, factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new EventFormatter<T>(this.handler2, this.factory, encoding);
        }

        public static final class Builder<T> {
            @Generated
            private OutputHandler2<XMLEventWriter, T> handler2;
            @Generated
            private boolean factory$set;
            @Generated
            private IOSupplier<? extends XMLOutputFactory> factory$value;
            @Generated
            private boolean encoding$set;
            @Generated
            private Charset encoding$value;

            @Deprecated
            public Builder<T> handler(OutputHandler<XMLEventWriter, T> handler) {
                return this.handler2(handler.withEncoding());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler2(@NonNull OutputHandler2<XMLEventWriter, T> handler2) {
                if (handler2 == null) {
                    throw new NullPointerException("handler2 is marked non-null but is null");
                }
                this.handler2 = handler2;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding$value = encoding;
                this.encoding$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> build() {
                IOSupplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = EventFormatter.$default$factory();
                }
                Charset encoding$value = this.encoding$value;
                if (!this.encoding$set) {
                    encoding$value = EventFormatter.$default$encoding();
                }
                return new EventFormatter<T>(this.handler2, (IOSupplier<? extends XMLOutputFactory>)factory$value, encoding$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.EventFormatter.Builder(handler2=" + this.handler2 + ", factory$value=" + this.factory$value + ", encoding$value=" + this.encoding$value + ")";
            }
        }
    }

    public static final class StreamFormatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final OutputHandler2<XMLStreamWriter, T> handler2;
        @NonNull
        private final IOSupplier<? extends XMLOutputFactory> factory;
        @NonNull
        private final Charset encoding;

        @Deprecated
        @NonNull
        public static <T> StreamFormatter<T> valueOf(@NonNull OutputHandler<XMLStreamWriter, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return StreamFormatter.of(handler.withEncoding());
        }

        @NonNull
        public static <T> StreamFormatter<T> of(@NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return StreamFormatter.builder().handler2(handler2).build();
        }

        @Deprecated
        public StreamFormatter<T> withHandler(OutputHandler<XMLStreamWriter, T> handler) {
            return this.withHandler2(handler.withEncoding());
        }

        @Override
        public boolean isFormatted() {
            return false;
        }

        @Override
        @NonNull
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (OutputStream resource = LegacyFiles.openOutputStream((File)target);){
                this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(@NonNull T value, @NonNull IOSupplier<? extends Writer> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (Writer resource = LegacyFiles.openWriter(target);){
                this.format(value, o -> o.createXMLStreamWriter(resource), this.getDefaultEncoding());
            }
        }

        public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            try (OutputStream resource = LegacyFiles.openOutputStream(target);){
                this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLStreamWriter(resource), this.getDefaultEncoding());
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.format(value, o -> o.createXMLStreamWriter(resource, encoding.name()), encoding);
        }

        private void format(T value, StaxFunction<XMLOutputFactory, XMLStreamWriter> supplier, Charset realEncoding) throws IOException {
            try {
                XMLStreamWriter output = supplier.applyWithXMLStream(this.getEngine());
                Stax.doFormat(this.handler2, value, output, realEncoding, Stax.asCloseable(output::close));
                output.close();
            }
            catch (XMLStreamException ex) {
                throw Stax.wrapXMLStreamException(ex);
            }
        }

        private XMLOutputFactory getEngine() throws IOException {
            return (XMLOutputFactory)this.factory.getWithIO();
        }

        @Generated
        private static <T> IOSupplier<? extends XMLOutputFactory> $default$factory() {
            return XMLOutputFactory::newFactory;
        }

        @Generated
        private static <T> Charset $default$encoding() {
            return StandardCharsets.UTF_8;
        }

        @Generated
        StreamFormatter(@NonNull OutputHandler2<XMLStreamWriter, T> handler2, @NonNull IOSupplier<? extends XMLOutputFactory> factory, @NonNull Charset encoding) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.handler2 = handler2;
            this.factory = factory;
            this.encoding = encoding;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler2(this.handler2).factory(this.factory).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withHandler2(@NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return this.handler2 == handler2 ? this : new StreamFormatter<T>(handler2, this.factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withFactory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new StreamFormatter<T>(this.handler2, factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new StreamFormatter<T>(this.handler2, this.factory, encoding);
        }

        public static final class Builder<T> {
            @Generated
            private OutputHandler2<XMLStreamWriter, T> handler2;
            @Generated
            private boolean factory$set;
            @Generated
            private IOSupplier<? extends XMLOutputFactory> factory$value;
            @Generated
            private boolean encoding$set;
            @Generated
            private Charset encoding$value;

            @Deprecated
            public Builder<T> handler(OutputHandler<XMLStreamWriter, T> handler) {
                return this.handler2(handler.withEncoding());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler2(@NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
                if (handler2 == null) {
                    throw new NullPointerException("handler2 is marked non-null but is null");
                }
                this.handler2 = handler2;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding$value = encoding;
                this.encoding$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> build() {
                IOSupplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = StreamFormatter.$default$factory();
                }
                Charset encoding$value = this.encoding$value;
                if (!this.encoding$set) {
                    encoding$value = StreamFormatter.$default$encoding();
                }
                return new StreamFormatter<T>(this.handler2, (IOSupplier<? extends XMLOutputFactory>)factory$value, encoding$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.StreamFormatter.Builder(handler2=" + this.handler2 + ", factory$value=" + this.factory$value + ", encoding$value=" + this.encoding$value + ")";
            }
        }
    }

    public static final class EventParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLEventReader, T> handler;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> factory;
        private final boolean ignoreXXE;

        @NonNull
        public static <T> EventParser<T> flowOf(@NonNull FlowHandler<XMLEventReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return EventParser.builder().flow(handler).build();
        }

        @NonNull
        public static <T> EventParser<T> valueOf(@NonNull ValueHandler<XMLEventReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return EventParser.flowOf(handler.asFlow());
        }

        @NonNull
        public T parseFile(@NonNull File source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream((File)source);
            return this.doParseOrClose(o -> o.createXMLEventReader(LegacyFiles.toSystemId((File)source), resource), resource);
        }

        @NonNull
        public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream((File)source);
            return this.doParseOrClose(o -> o.createXMLEventReader(LegacyFiles.toSystemId((File)source), resource), resource);
        }

        @NonNull
        public T parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            Reader resource = LegacyFiles.openReader(source);
            return this.doParseOrClose(o -> o.createXMLEventReader(resource), resource);
        }

        @NonNull
        public T parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream(source);
            return this.doParseOrClose(o -> o.createXMLEventReader(resource), resource);
        }

        @NonNull
        public T parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream(source);
            return this.doParseOrClose(o -> o.createXMLEventReader(resource, encoding.name()), resource);
        }

        @NonNull
        public T parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLEventReader(resource), NOTHING_TO_CLOSE);
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLEventReader(Resource.uncloseableInputStream((InputStream)resource)), NOTHING_TO_CLOSE);
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLEventReader(Resource.uncloseableInputStream((InputStream)resource), encoding.name()), NOTHING_TO_CLOSE);
        }

        private T doParseOrClose(StaxFunction<XMLInputFactory, XMLEventReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLEventReader input = (XMLEventReader)Stax.asIOFunction(supplier).applyWithIO((Object)this.getEngine());
                return (T)Stax.doParse(this.handler, input, Stax.asCloseable(input::close, onClose));
            }
            catch (IOException | Error | RuntimeException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            return Stax.getInputEngine((IOSupplier<? extends XMLInputFactory>)this.factory, this.ignoreXXE);
        }

        @Generated
        private static <T> IOSupplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newInstance;
        }

        @Generated
        private static <T> boolean $default$ignoreXXE() {
            return false;
        }

        @Generated
        EventParser(@NonNull FlowHandler<XMLEventReader, T> handler, @NonNull IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).ignoreXXE(this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withHandler(@NonNull FlowHandler<XMLEventReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return this.handler == handler ? this : new EventParser<T>(handler, this.factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withFactory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new EventParser<T>(this.handler, factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new EventParser<T>(this.handler, this.factory, ignoreXXE);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private FlowHandler<XMLEventReader, T> handler;
            @Generated
            private boolean factory$set;
            @Generated
            private IOSupplier<? extends XMLInputFactory> factory$value;
            @Generated
            private boolean ignoreXXE$set;
            @Generated
            private boolean ignoreXXE$value;

            public Builder<T> flow(FlowHandler<XMLEventReader, T> handler) {
                return this.handler(handler);
            }

            public Builder<T> value(ValueHandler<XMLEventReader, T> handler) {
                return this.handler(handler.asFlow());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler(@NonNull FlowHandler<XMLEventReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE$value = ignoreXXE;
                this.ignoreXXE$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> build() {
                IOSupplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = EventParser.$default$factory();
                }
                boolean ignoreXXE$value = this.ignoreXXE$value;
                if (!this.ignoreXXE$set) {
                    ignoreXXE$value = EventParser.$default$ignoreXXE();
                }
                return new EventParser<T>(this.handler, (IOSupplier<? extends XMLInputFactory>)factory$value, ignoreXXE$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.EventParser.Builder(handler=" + this.handler + ", factory$value=" + this.factory$value + ", ignoreXXE$value=" + this.ignoreXXE$value + ")";
            }
        }
    }

    public static final class StreamParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLStreamReader, T> handler;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> factory;
        private final boolean ignoreXXE;

        @NonNull
        public static <T> StreamParser<T> flowOf(@NonNull FlowHandler<XMLStreamReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return StreamParser.builder().flow(handler).build();
        }

        @NonNull
        public static <T> StreamParser<T> valueOf(@NonNull ValueHandler<XMLStreamReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return StreamParser.flowOf(handler.asFlow());
        }

        @NonNull
        public T parseFile(@NonNull File source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream((File)source);
            return this.doParseOrClose(o -> o.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource), resource);
        }

        @NonNull
        public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream((File)source);
            return this.doParseOrClose(o -> o.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource), resource);
        }

        @NonNull
        public T parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            Reader resource = LegacyFiles.openReader(source);
            return this.doParseOrClose(o -> o.createXMLStreamReader(resource), resource);
        }

        @NonNull
        public T parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream(source);
            return this.doParseOrClose(o -> o.createXMLStreamReader(resource), resource);
        }

        @NonNull
        public T parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            InputStream resource = LegacyFiles.openInputStream(source);
            return this.doParseOrClose(o -> o.createXMLStreamReader(resource, encoding.name()), resource);
        }

        @NonNull
        public T parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLStreamReader(resource), NOTHING_TO_CLOSE);
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLStreamReader(Resource.uncloseableInputStream((InputStream)resource)), NOTHING_TO_CLOSE);
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.doParseOrClose(o -> o.createXMLStreamReader(Resource.uncloseableInputStream((InputStream)resource), encoding.name()), NOTHING_TO_CLOSE);
        }

        @NonNull
        public T parse(@NonNull XMLStreamReader input, @NonNull Closeable onClose) throws IOException {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            if (onClose == null) {
                throw new NullPointerException("onClose is marked non-null but is null");
            }
            return (T)Stax.doParse(this.handler, input, onClose);
        }

        private T doParseOrClose(StaxFunction<XMLInputFactory, XMLStreamReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLStreamReader input = (XMLStreamReader)Stax.asIOFunction(supplier).applyWithIO((Object)this.getEngine());
                return (T)Stax.doParse(this.handler, input, Stax.asCloseable(input::close, onClose));
            }
            catch (IOException | Error | RuntimeException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            return Stax.getInputEngine((IOSupplier<? extends XMLInputFactory>)this.factory, this.ignoreXXE);
        }

        @Generated
        private static <T> IOSupplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newInstance;
        }

        @Generated
        private static <T> boolean $default$ignoreXXE() {
            return false;
        }

        @Generated
        StreamParser(@NonNull FlowHandler<XMLStreamReader, T> handler, @NonNull IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).ignoreXXE(this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withHandler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return this.handler == handler ? this : new StreamParser<T>(handler, this.factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withFactory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new StreamParser<T>(this.handler, factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new StreamParser<T>(this.handler, this.factory, ignoreXXE);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private FlowHandler<XMLStreamReader, T> handler;
            @Generated
            private boolean factory$set;
            @Generated
            private IOSupplier<? extends XMLInputFactory> factory$value;
            @Generated
            private boolean ignoreXXE$set;
            @Generated
            private boolean ignoreXXE$value;

            public Builder<T> flow(FlowHandler<XMLStreamReader, T> handler) {
                return this.handler(handler);
            }

            public Builder<T> value(ValueHandler<XMLStreamReader, T> handler) {
                return this.handler(handler.asFlow());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE$value = ignoreXXE;
                this.ignoreXXE$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> build() {
                IOSupplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = StreamParser.$default$factory();
                }
                boolean ignoreXXE$value = this.ignoreXXE$value;
                if (!this.ignoreXXE$set) {
                    ignoreXXE$value = StreamParser.$default$ignoreXXE();
                }
                return new StreamParser<T>(this.handler, (IOSupplier<? extends XMLInputFactory>)factory$value, ignoreXXE$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.StreamParser.Builder(handler=" + this.handler + ", factory$value=" + this.factory$value + ", ignoreXXE$value=" + this.ignoreXXE$value + ")";
            }
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface OutputHandler<O, T> {
        public void format(@NonNull T var1, @NonNull O var2) throws Exception;

        default public OutputHandler2<O, T> withEncoding() {
            return (t, o, e) -> this.format(t, o);
        }
    }

    @FunctionalInterface
    public static interface ValueHandler<I, T> {
        @NonNull
        public T parse(@NonNull I var1) throws XMLStreamException;

        @NonNull
        default public FlowHandler<I, T> asFlow() {
            return (input, onClose) -> {
                try (Closeable ignored = onClose;){
                    T t = this.parse(input);
                    return t;
                }
            };
        }
    }
}

