/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.net.MediaType;
import nbbrd.io.text.TextFormatter;
import nbbrd.io.text.TextParser;

public final class Xml {
    public static final MediaType XML_UTF_8 = MediaType.builder().type("text").subtype("xml").build().withCharset(StandardCharsets.UTF_8);
    public static final MediaType APPLICATION_XML_UTF_8 = MediaType.builder().type("application").subtype("xml").build().withCharset(StandardCharsets.UTF_8);

    @Generated
    private Xml() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class AdaptedFormatter<V>
    implements Formatter<V> {
        @NonNull
        private final Formatter<?> delegate;
        @NonNull
        private final FileFormatter<V> fileFormatter;
        @NonNull
        private final TextFormatter<V> textFormatter;

        @Override
        public boolean isFormatted() {
            return this.delegate.isFormatted();
        }

        @Override
        @NonNull
        public Charset getDefaultEncoding() {
            return this.delegate.getDefaultEncoding();
        }

        public void formatFile(@NonNull V value, @NonNull File target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.fileFormatter.formatFile(value, target);
        }

        public void formatPath(@NonNull V value, @NonNull Path target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.fileFormatter.formatPath(value, target);
        }

        public void formatStream(@NonNull V value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.fileFormatter.formatStream(value, target);
        }

        public void formatStream(@NonNull V value, @NonNull OutputStream resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.fileFormatter.formatStream(value, resource);
        }

        @NonNull
        public String formatToString(@NonNull V value) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.textFormatter.formatToString(value);
        }

        public void formatChars(@NonNull V value, @NonNull Appendable target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.textFormatter.formatChars(value, target);
        }

        public void formatFile(@NonNull V value, @NonNull File target, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.textFormatter.formatFile(value, target, encoding);
        }

        public void formatPath(@NonNull V value, @NonNull Path target, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.textFormatter.formatPath(value, target, encoding);
        }

        public void formatWriter(@NonNull V value, @NonNull IOSupplier<? extends Writer> target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.textFormatter.formatWriter(value, target);
        }

        public void formatStream(@NonNull V value, @NonNull IOSupplier<? extends OutputStream> target, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.textFormatter.formatStream(value, target, encoding);
        }

        public void formatWriter(@NonNull V value, @NonNull Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.textFormatter.formatWriter(value, resource);
        }

        public void formatStream(@NonNull V value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.textFormatter.formatStream(value, resource, encoding);
        }

        @Generated
        public AdaptedFormatter(@NonNull Formatter<?> delegate, @NonNull FileFormatter<V> fileFormatter, @NonNull TextFormatter<V> textFormatter) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (fileFormatter == null) {
                throw new NullPointerException("fileFormatter is marked non-null but is null");
            }
            if (textFormatter == null) {
                throw new NullPointerException("textFormatter is marked non-null but is null");
            }
            this.delegate = delegate;
            this.fileFormatter = fileFormatter;
            this.textFormatter = textFormatter;
        }
    }

    private static final class AdaptedParser<V>
    implements Parser<V> {
        @NonNull
        private final Parser<?> delegate;
        @NonNull
        private final FileParser<V> fileParser;
        @NonNull
        private final TextParser<V> textParser;

        @Override
        public boolean isIgnoreXXE() {
            return this.delegate.isIgnoreXXE();
        }

        @NonNull
        public V parseFile(@NonNull File source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return (V)this.fileParser.parseFile(source);
        }

        @NonNull
        public V parsePath(@NonNull Path source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return (V)this.fileParser.parsePath(source);
        }

        @NonNull
        public V parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return (V)this.fileParser.parseResource(type, name);
        }

        @NonNull
        public V parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return (V)this.fileParser.parseStream(source);
        }

        @NonNull
        public V parseStream(@NonNull InputStream resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return (V)this.fileParser.parseStream(resource);
        }

        @NonNull
        public V parseChars(@NonNull CharSequence source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return (V)this.textParser.parseChars(source);
        }

        @NonNull
        public V parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return (V)this.textParser.parseFile(source, encoding);
        }

        @NonNull
        public V parsePath(@NonNull Path source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return (V)this.textParser.parsePath(source, encoding);
        }

        @NonNull
        public V parseResource(@NonNull Class<?> type, @NonNull String name, @NonNull Charset encoding) throws IOException {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return (V)this.textParser.parseResource(type, name, encoding);
        }

        @NonNull
        public V parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return (V)this.textParser.parseReader(source);
        }

        @NonNull
        public V parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return (V)this.textParser.parseStream(source, encoding);
        }

        @NonNull
        public V parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return (V)this.textParser.parseReader(resource);
        }

        @NonNull
        public V parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return (V)this.textParser.parseStream(resource, encoding);
        }

        @Generated
        public AdaptedParser(@NonNull Parser<?> delegate, @NonNull FileParser<V> fileParser, @NonNull TextParser<V> textParser) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (fileParser == null) {
                throw new NullPointerException("fileParser is marked non-null but is null");
            }
            if (textParser == null) {
                throw new NullPointerException("textParser is marked non-null but is null");
            }
            this.delegate = delegate;
            this.fileParser = fileParser;
            this.textParser = textParser;
        }
    }

    public static interface Formatter<T>
    extends FileFormatter<T>,
    TextFormatter<T> {
        public boolean isFormatted();

        @NonNull
        public Charset getDefaultEncoding();

        @NonNull
        default public <V> Formatter<V> compose(@NonNull IOFunction<? super V, ? extends T> before) {
            if (before == null) {
                throw new NullPointerException("before is marked non-null but is null");
            }
            return new AdaptedFormatter(this, super.compose(before), super.compose(before));
        }
    }

    public static interface Parser<T>
    extends FileParser<T>,
    TextParser<T> {
        public boolean isIgnoreXXE();

        @NonNull
        default public <V> Parser<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
            if (after == null) {
                throw new NullPointerException("after is marked non-null but is null");
            }
            return new AdaptedParser(this, super.andThen(after), super.andThen(after));
        }
    }
}

