/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public enum SqlKeywords {
    SQL92_RESERVED_WORDS("Sql92ReservedWords.txt"),
    SQL92_NON_RESERVED_WORDS("Sql92NonReservedWords.txt"),
    SQL99_RESERVED_WORDS("Sql99ReservedWords.txt"),
    SQL2003_RESERVED_WORDS("Sql2003ReservedWords.txt"),
    SQL2008_RESERVED_WORDS("Sql2008ReservedWords.txt"),
    SQL2011_RESERVED_WORDS("Sql2011ReservedWords.txt"),
    SQL2016_RESERVED_WORDS("Sql2016ReservedWords.txt"),
    LATEST_RESERVED_WORDS("Sql2016ReservedWords.txt");

    private final Set<String> keywords;

    private SqlKeywords(String resourceName) {
        this.keywords = SqlKeywords.loadWords(resourceName);
    }

    private static Set<String> loadWords(String resourceName) {
        Set set;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(SqlKeywords.class.getResourceAsStream(resourceName)), StandardCharsets.UTF_8));
        try {
            set = reader.lines().collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Missing resource '" + resourceName + "'", ex);
            }
            catch (UncheckedIOException ex) {
                throw new RuntimeException("Missing resource '" + resourceName + "'", ex.getCause());
            }
        }
        reader.close();
        return set;
    }

    @Generated
    public Set<String> getKeywords() {
        return this.keywords;
    }
}

