/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.TabDataColumn;
import internal.sql.lhod._ResultSetMetaData;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LhodResultSetMetaData
extends _ResultSetMetaData {
    @lombok.NonNull
    private final String[] names;
    @lombok.NonNull
    private final DataTypeEnum[] types;

    static @NonNull LhodResultSetMetaData of(@NonNull List<TabDataColumn> columns) {
        String[] names = new String[columns.size()];
        DataTypeEnum[] types = new DataTypeEnum[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            names[i] = columns.get(i).getName();
            types[i] = DataTypeEnum.parse(columns.get(i).getType());
        }
        return new LhodResultSetMetaData(names, types);
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column - 1];
    }

    @Override
    public int getColumnType(int column) {
        return this.types[column - 1].sqlType;
    }

    @Override
    public String getColumnClassName(int column) {
        return String.class.getName();
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return -1;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.types[column - 1].name();
    }

    private LhodResultSetMetaData(@lombok.NonNull String[] names, @lombok.NonNull DataTypeEnum[] types) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        if (types == null) {
            throw new NullPointerException("types is marked non-null but is null");
        }
        this.names = names;
        this.types = types;
    }

    public static LhodResultSetMetaData of(@lombok.NonNull String[] names, @lombok.NonNull DataTypeEnum[] types) {
        return new LhodResultSetMetaData(names, types);
    }

    private static enum DataTypeEnum {
        adEmpty(0, 1111),
        adSmallInt(2, 5),
        adInteger(3, 4),
        adSingle(4, 1111),
        adDouble(5, 8),
        adCurrency(6, 1111),
        adDate(7, 91),
        adBSTR(8, 12),
        adIDispatch(9, 1111),
        adError(10, 1111),
        adBoolean(11, 16),
        adVariant(12, 1111),
        adIUnknown(13, 1111),
        adDecimal(14, 3),
        adTinyInt(16, -6),
        adUnsignedTinyInt(17, -6),
        adUnsignedSmallInt(18, 5),
        adUnsignedInt(19, 4),
        adBigInt(20, -5),
        adUnsignedBigInt(21, -5),
        adFileTime(64, 1111),
        adGUID(72, 1111),
        adBinary(128, 1111),
        adChar(129, 1),
        adWChar(130, 1111),
        adNumeric(131, 2),
        adUserDefined(132, 1111),
        adDBDate(133, 91),
        adDBTime(134, 92),
        adDBTimeStamp(135, 93),
        adChapter(136, 1111),
        adPropVariant(138, 1111),
        adVarNumeric(139, 1111),
        adVarChar(200, 12),
        adLongVarChar(201, 1111),
        adVarWChar(202, 1111),
        adLongVarWChar(203, 1111),
        adVarBinary(204, -3),
        adLongVarBinary(205, -3),
        adArray(8192, 2003);

        private final int value;
        private final int sqlType;

        public static DataTypeEnum parse(int value) {
            for (DataTypeEnum o : DataTypeEnum.values()) {
                if (o.value != value) continue;
                return o;
            }
            return adIUnknown;
        }

        private DataTypeEnum(int value, int sqlType) {
            this.value = value;
            this.sqlType = sqlType;
        }

        public int getValue() {
            return this.value;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }
}

