/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.picocsv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public final class Csv {
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int EOF_CODE = -1;

    private Csv() {
    }

    private static RuntimeException newUnreachable() {
        return new RuntimeException("Unreachable");
    }

    private static void requireArgument(boolean condition, String format, Object arg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, format, arg));
        }
    }

    private static String prettyPrint(String text) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            result.append(Csv.prettyPrint(text.charAt(i)));
        }
        return result.toString();
    }

    private static String prettyPrint(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    public static final class Writer
    implements LineWriter,
    Flushable,
    Closeable {
        private final Output output;
        private final char quote;
        private final char delimiter;
        private final char comment;
        private final EndOfLineEncoder eolEncoder;
        private int state = 0;
        private static final int QUOTING_NONE = 0;
        private static final int QUOTING_PARTIAL = 1;
        private static final int QUOTING_FULL = 2;
        private static final int STATE_NO_FIELD = 0;
        private static final int STATE_SINGLE_EMPTY_FIELD = 1;
        private static final int STATE_MULTI_FIELD = 2;

        public static Writer of(Format format, WriterOptions options, java.io.Writer charWriter) throws IllegalArgumentException, IOException {
            return Writer.of(format, options, charWriter, 8192);
        }

        public static Writer of(Format format, WriterOptions options, java.io.Writer charWriter, int charBufferSize) throws IllegalArgumentException, IOException {
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charWriter, "charWriter");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            return new Writer(new Output(charWriter, new char[charBufferSize]), format.getQuote(), format.getDelimiter(), format.getComment(), EndOfLineEncoder.of(format));
        }

        private Writer(Output output, char quote, char delimiter, char comment, EndOfLineEncoder eolEncoder) {
            this.output = output;
            this.quote = quote;
            this.delimiter = delimiter;
            this.comment = comment;
            this.eolEncoder = eolEncoder;
        }

        @Override
        public void writeComment(CharSequence comment) throws IOException {
            if (this.state != 0) {
                this.writeEndOfLine();
            }
            this.output.write(this.comment);
            if (comment != null && comment.length() > 0) {
                for (int i = 0; i < comment.length(); ++i) {
                    char c = comment.charAt(i);
                    if (this.eolEncoder.isNewLine(c)) {
                        this.writeEndOfLine();
                        this.output.write(this.comment);
                        if (!this.isSkipSecondEOL(comment, i)) continue;
                        ++i;
                        continue;
                    }
                    this.output.write(c);
                }
            }
            this.writeEndOfLine();
        }

        private boolean isSkipSecondEOL(CharSequence text, int i) {
            return this.eolEncoder instanceof EndOfLineEncoder.DualEncoder && i + 1 < text.length() && this.eolEncoder.isNewLine(text.charAt(i + 1));
        }

        @Override
        public void writeField(CharSequence field) throws IOException {
            switch (this.state) {
                case 0: {
                    if (this.isNotEmpty(field)) {
                        this.state = 2;
                        if (field.charAt(0) == this.comment) {
                            this.writeNonEmptyField(field, 2);
                            break;
                        }
                        this.writeNonEmptyField(field);
                        break;
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 2;
                    this.output.write(this.delimiter);
                    if (!this.isNotEmpty(field)) break;
                    this.writeNonEmptyField(field);
                    break;
                }
                case 2: {
                    this.output.write(this.delimiter);
                    if (!this.isNotEmpty(field)) break;
                    this.writeNonEmptyField(field);
                }
            }
        }

        public void writeEndOfLine() throws IOException {
            this.flush();
            this.eolEncoder.write(this.output);
        }

        @Override
        public void flush() throws IOException {
            if (this.state == 1) {
                this.output.write(this.quote);
                this.output.write(this.quote);
            }
            this.state = 0;
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.output.close();
        }

        private boolean isNotEmpty(CharSequence field) {
            return field != null && field.length() != 0;
        }

        private void writeNonEmptyField(CharSequence field) throws IOException {
            this.writeNonEmptyField(field, this.getQuoting(field));
        }

        private void writeNonEmptyField(CharSequence field, int quoting) throws IOException {
            switch (quoting) {
                case 0: {
                    this.output.write(field);
                    break;
                }
                case 1: {
                    this.output.write(this.quote);
                    this.output.write(field);
                    this.output.write(this.quote);
                    break;
                }
                case 2: {
                    this.output.write(this.quote);
                    for (int i = 0; i < field.length(); ++i) {
                        char c = field.charAt(i);
                        if (c == this.quote) {
                            this.output.write(c);
                        }
                        this.output.write(c);
                    }
                    this.output.write(this.quote);
                }
            }
        }

        private int getQuoting(CharSequence field) {
            int result = 0;
            for (int i = 0; i < field.length(); ++i) {
                char c = field.charAt(i);
                if (c == this.quote) {
                    return 2;
                }
                if (c != this.delimiter && !this.eolEncoder.isNewLine(c)) continue;
                result = 1;
            }
            return result;
        }

        private static final class Output
        implements Closeable,
        Flushable {
            private final java.io.Writer charWriter;
            private final char[] buffer;
            private int length = 0;

            private Output(java.io.Writer charWriter, char[] charBuffer) {
                this.charWriter = charWriter;
                this.buffer = charBuffer;
            }

            public void write(char c) throws IOException {
                if (this.length == this.buffer.length) {
                    this.flushBuffer();
                }
                this.buffer[this.length++] = c;
            }

            public void write(CharSequence chars) throws IOException {
                int charsLength = chars.length();
                if (this.length + charsLength >= this.buffer.length) {
                    this.flushBuffer();
                    if (charsLength >= this.buffer.length) {
                        this.charWriter.append(chars);
                        return;
                    }
                }
                if (chars instanceof String) {
                    ((String)chars).getChars(0, charsLength, this.buffer, this.length);
                    this.length += charsLength;
                } else {
                    for (int i = 0; i < charsLength; ++i) {
                        this.buffer[this.length++] = chars.charAt(i);
                    }
                }
            }

            @Override
            public void close() throws IOException {
                this.flushBuffer();
                this.charWriter.close();
            }

            private void flushBuffer() throws IOException {
                this.charWriter.write(this.buffer, 0, this.length);
                this.length = 0;
            }

            @Override
            public void flush() throws IOException {
                if (this.length != 0) {
                    this.flushBuffer();
                }
                this.charWriter.flush();
            }
        }

        private static abstract class EndOfLineEncoder {
            private EndOfLineEncoder() {
            }

            public abstract void write(Output var1) throws IOException;

            public abstract boolean isNewLine(char var1);

            public static EndOfLineEncoder of(Format format) {
                String eol = format.getSeparator();
                switch (eol.length()) {
                    case 1: {
                        return new SingleEncoder(eol.charAt(0));
                    }
                    case 2: {
                        return new DualEncoder(eol.charAt(0), eol.charAt(1));
                    }
                }
                throw Csv.newUnreachable();
            }

            private static final class SingleEncoder
            extends EndOfLineEncoder {
                private final char single;

                private SingleEncoder(char single) {
                    this.single = single;
                }

                @Override
                public void write(Output output) throws IOException {
                    output.write(this.single);
                }

                @Override
                public boolean isNewLine(char c) {
                    return c == this.single;
                }
            }

            private static final class DualEncoder
            extends EndOfLineEncoder {
                private final char first;
                private final char second;

                private DualEncoder(char first, char second) {
                    this.first = first;
                    this.second = second;
                }

                @Override
                public void write(Output output) throws IOException {
                    output.write(this.first);
                    output.write(this.second);
                }

                @Override
                public boolean isNewLine(char c) {
                    return c == this.first || c == this.second;
                }
            }
        }
    }

    public static interface LineWriter {
        public void writeComment(CharSequence var1) throws IOException;

        public void writeField(CharSequence var1) throws IOException;
    }

    public static final class WriterOptions {
        public static final WriterOptions DEFAULT = new WriterOptions();

        private WriterOptions() {
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriterOptions other = (WriterOptions)obj;
            return true;
        }

        public String toString() {
            return "WriterOptions()";
        }

        public Builder toBuilder() {
            return new Builder();
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private Builder() {
            }

            public WriterOptions build() {
                return new WriterOptions();
            }
        }
    }

    public static final class Reader
    implements LineReader,
    Closeable {
        private final java.io.Reader charReader;
        private final char[] buffer;
        private final int quoteCode;
        private final int delimiterCode;
        private final int commentCode;
        private final byte emptyLineState;
        private final char[] fieldChars;
        private final byte eolType;
        private final int eolCode0;
        private final int eolCode1;
        private int bufferLength = 0;
        private int bufferIndex = 0;
        private int fieldLength = 0;
        private byte fieldType = (byte)10;
        private byte state = 0;
        private static final byte STATE_0_READY = 0;
        private static final byte STATE_1_FIRST = 1;
        private static final byte STATE_2_NOT_LAST = 2;
        private static final byte STATE_3_LAST = 3;
        private static final byte STATE_4_SINGLE = 4;
        private static final byte STATE_5_MISSING = 5;
        private static final byte STATE_6_DONE = 6;
        private static final byte FIELD_TYPE_NORMAL = 10;
        private static final byte FIELD_TYPE_QUOTED = 11;
        private static final byte FIELD_TYPE_COMMENTED = 12;
        private static final byte EOL_TYPE_SINGLE = 20;
        private static final byte EOL_TYPE_DUAL_STRICT = 21;
        private static final byte EOL_TYPE_DUAL_LENIENT = 22;

        public static Reader of(Format format, ReaderOptions options, java.io.Reader charReader) throws IllegalArgumentException, IOException {
            return Reader.of(format, options, charReader, 8192);
        }

        public static Reader of(Format format, ReaderOptions options, java.io.Reader charReader, int charBufferSize) throws IllegalArgumentException, IOException {
            int eolCode1;
            char eolCode0;
            byte eolType;
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charReader, "charReader");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            Csv.requireArgument(options.isValid(), "Invalid options: %s", options);
            char[] charBuffer = new char[charBufferSize];
            if (format.getSeparator().length() == 1) {
                eolType = 20;
                eolCode0 = format.getSeparator().charAt(0);
                eolCode1 = -1;
            } else {
                eolType = options.isLenientSeparator() ? (byte)22 : 21;
                eolCode0 = format.getSeparator().charAt(0);
                eolCode1 = format.getSeparator().charAt(1);
            }
            return new Reader(charReader, charBuffer, format.getQuote(), format.getDelimiter(), format.getComment(), format.isAcceptMissingField() ? (byte)5 : 4, new char[options.getMaxCharsPerField()], eolType, eolCode0, eolCode1);
        }

        private Reader(java.io.Reader charReader, char[] buffer, int quoteCode, int delimiterCode, int commentCode, byte emptyLineState, char[] fieldChars, byte eolType, int eolCode0, int eolCode1) {
            this.charReader = charReader;
            this.buffer = buffer;
            this.quoteCode = quoteCode;
            this.delimiterCode = delimiterCode;
            this.commentCode = commentCode;
            this.emptyLineState = emptyLineState;
            this.fieldChars = fieldChars;
            this.eolType = eolType;
            this.eolCode0 = eolCode0;
            this.eolCode1 = eolCode1;
        }

        public boolean readLine() throws IOException {
            switch (this.state) {
                case 0: {
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 1: {
                    this.skipRemainingFields();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 2: {
                    this.skipRemainingFields();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 3: {
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 4: {
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 5: {
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 6: {
                    return false;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return false;
                }
            }
            throw Csv.newUnreachable();
        }

        @Override
        public boolean readField() throws IOException {
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    this.state = (byte)2;
                    return true;
                }
                case 2: {
                    this.parseNextField(false);
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    this.state = (byte)3;
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return false;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return false;
                }
            }
            throw Csv.newUnreachable();
        }

        @Override
        public boolean isComment() {
            return this.fieldType == 12;
        }

        @Override
        public void close() throws IOException {
            this.charReader.close();
        }

        private void skipRemainingFields() throws IOException {
            do {
                this.parseNextField(false);
            } while (this.state == 2);
        }

        private void parseNextField(boolean firstField) throws IOException {
            int fieldLength = this.fieldLength;
            int i = this.bufferIndex;
            int l = this.bufferLength;
            try {
                int firstCode;
                int n;
                int quoteCode = this.quoteCode;
                int delimiterCode = this.delimiterCode;
                char[] fieldChars = this.fieldChars;
                java.io.Reader s = this.charReader;
                char[] b = this.buffer;
                byte eolType = this.eolType;
                int eolCode0 = this.eolCode0;
                int eolCode1 = this.eolCode1;
                fieldLength = 0;
                if (i < l) {
                    n = b[i++];
                } else {
                    l = s.read(b);
                    if (l == -1) {
                        n = -1;
                    } else {
                        i = 1;
                        n = firstCode = b[1 - 1];
                    }
                }
                if (n != -1) {
                    if (firstCode == quoteCode) {
                        this.fieldType = (byte)11;
                        boolean escaped = false;
                        while (true) {
                            int subCode;
                            int n2;
                            if (i < l) {
                                n2 = b[i++];
                            } else {
                                l = s.read(b);
                                if (l == -1) {
                                    n2 = -1;
                                } else {
                                    i = 1;
                                    n2 = subCode = b[1 - 1];
                                }
                            }
                            if (n2 == -1) break;
                            if (subCode == quoteCode) {
                                if (!escaped) {
                                    escaped = true;
                                    continue;
                                }
                                escaped = false;
                                fieldChars[fieldLength++] = (char)subCode;
                                continue;
                            }
                            if (escaped) {
                                if (subCode == delimiterCode) {
                                    this.state = (byte)(firstField ? 1 : 2);
                                    return;
                                }
                                if (subCode == eolCode0) {
                                    switch (eolType) {
                                        case 20: {
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                        case 21: {
                                            int n3;
                                            if (i < l) {
                                                n3 = b[i++];
                                            } else {
                                                l = s.read(b);
                                                if (l == -1) {
                                                    n3 = -1;
                                                } else {
                                                    i = 1;
                                                    n3 = b[1 - 1];
                                                }
                                            }
                                            if (n3 != eolCode1) {
                                                --i;
                                                break;
                                            }
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                        case 22: {
                                            int n4;
                                            if (i < l) {
                                                n4 = b[i++];
                                            } else {
                                                l = s.read(b);
                                                if (l == -1) {
                                                    n4 = -1;
                                                } else {
                                                    i = 1;
                                                    n4 = b[1 - 1];
                                                }
                                            }
                                            if (n4 != eolCode1) {
                                                --i;
                                            }
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                    }
                                } else if (eolType == 22 && subCode == eolCode1) {
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                            }
                            fieldChars[fieldLength++] = (char)subCode;
                        }
                        this.state = (byte)(firstField ? 4 : 3);
                        return;
                    }
                    if (firstField && firstCode == this.commentCode) {
                        this.fieldType = (byte)12;
                        while (true) {
                            int subCode;
                            int n5;
                            if (i < l) {
                                n5 = b[i++];
                            } else {
                                l = s.read(b);
                                if (l == -1) {
                                    n5 = -1;
                                } else {
                                    i = 1;
                                    n5 = subCode = b[1 - 1];
                                }
                            }
                            if (n5 == -1) break;
                            if (subCode == eolCode0) {
                                switch (eolType) {
                                    case 20: {
                                        this.state = (byte)4;
                                        return;
                                    }
                                    case 21: {
                                        int n6;
                                        if (i < l) {
                                            n6 = b[i++];
                                        } else {
                                            l = s.read(b);
                                            if (l == -1) {
                                                n6 = -1;
                                            } else {
                                                i = 1;
                                                n6 = b[1 - 1];
                                            }
                                        }
                                        if (n6 != eolCode1) {
                                            --i;
                                            break;
                                        }
                                        this.state = (byte)4;
                                        return;
                                    }
                                    case 22: {
                                        int n7;
                                        if (i < l) {
                                            n7 = b[i++];
                                        } else {
                                            l = s.read(b);
                                            if (l == -1) {
                                                n7 = -1;
                                            } else {
                                                i = 1;
                                                n7 = b[1 - 1];
                                            }
                                        }
                                        if (n7 != eolCode1) {
                                            --i;
                                        }
                                        this.state = (byte)4;
                                        return;
                                    }
                                }
                            } else if (eolType == 22 && subCode == eolCode1) {
                                this.state = (byte)4;
                                return;
                            }
                            fieldChars[fieldLength++] = (char)subCode;
                        }
                        this.state = (byte)4;
                        return;
                    }
                    this.fieldType = (byte)10;
                    if (firstCode == delimiterCode) {
                        this.state = (byte)(firstField ? 1 : 2);
                        return;
                    }
                    if (firstCode == eolCode0) {
                        switch (eolType) {
                            case 20: {
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                            case 21: {
                                int n8;
                                if (i < l) {
                                    n8 = b[i++];
                                } else {
                                    l = s.read(b);
                                    if (l == -1) {
                                        n8 = -1;
                                    } else {
                                        i = 1;
                                        n8 = b[1 - 1];
                                    }
                                }
                                if (n8 != eolCode1) {
                                    --i;
                                    break;
                                }
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                            case 22: {
                                int n9;
                                if (i < l) {
                                    n9 = b[i++];
                                } else {
                                    l = s.read(b);
                                    if (l == -1) {
                                        n9 = -1;
                                    } else {
                                        i = 1;
                                        n9 = b[1 - 1];
                                    }
                                }
                                if (n9 != eolCode1) {
                                    --i;
                                }
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                        }
                    } else if (eolType == 22 && firstCode == eolCode1) {
                        this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                        return;
                    }
                    fieldChars[fieldLength++] = (char)firstCode;
                    while (true) {
                        int subCode;
                        int n10;
                        if (i < l) {
                            n10 = b[i++];
                        } else {
                            l = s.read(b);
                            if (l == -1) {
                                n10 = -1;
                            } else {
                                i = 1;
                                n10 = subCode = b[1 - 1];
                            }
                        }
                        if (n10 == -1) break;
                        if (subCode == delimiterCode) {
                            this.state = (byte)(firstField ? 1 : 2);
                            return;
                        }
                        if (subCode == eolCode0) {
                            switch (eolType) {
                                case 20: {
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                                case 21: {
                                    int n11;
                                    if (i < l) {
                                        n11 = b[i++];
                                    } else {
                                        l = s.read(b);
                                        if (l == -1) {
                                            n11 = -1;
                                        } else {
                                            i = 1;
                                            n11 = b[1 - 1];
                                        }
                                    }
                                    if (n11 != eolCode1) {
                                        --i;
                                        break;
                                    }
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                                case 22: {
                                    int n12;
                                    if (i < l) {
                                        n12 = b[i++];
                                    } else {
                                        l = s.read(b);
                                        if (l == -1) {
                                            n12 = -1;
                                        } else {
                                            i = 1;
                                            n12 = b[1 - 1];
                                        }
                                    }
                                    if (n12 != eolCode1) {
                                        --i;
                                    }
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                            }
                        } else if (eolType == 22 && subCode == eolCode1) {
                            this.state = (byte)(firstField ? 4 : 3);
                            return;
                        }
                        fieldChars[fieldLength++] = (char)subCode;
                    }
                    this.state = (byte)(fieldLength > 0 ? (firstField ? 4 : 3) : 6);
                    return;
                }
                this.state = (byte)6;
                return;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IOException("Field overflow", ex);
            }
            finally {
                this.fieldLength = fieldLength;
                this.bufferLength = l;
                this.bufferIndex = i;
            }
        }

        @Override
        public String toString() {
            return this.fieldLength == 0 ? "" : new String(this.fieldChars, 0, this.fieldLength);
        }

        @Override
        public int length() {
            return this.fieldLength;
        }

        @Override
        public char charAt(int index) {
            if (index >= this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.fieldChars[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end > this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(end));
            }
            return new String(this.fieldChars, start, end - start);
        }
    }

    public static interface LineReader
    extends CharSequence {
        public boolean readField() throws IOException;

        public boolean isComment();
    }

    public static final class ReaderOptions {
        private static final boolean DEFAULT_LENIENT_SEPARATOR = false;
        private static final int DEFAULT_MAX_CHARS_PER_FIELD = 4096;
        public static final ReaderOptions DEFAULT = new ReaderOptions(false, 4096);
        private final boolean lenientSeparator;
        private final int maxCharsPerField;

        private ReaderOptions(boolean lenientSeparator, int maxCharsPerField) {
            this.lenientSeparator = lenientSeparator;
            this.maxCharsPerField = maxCharsPerField;
        }

        public boolean isLenientSeparator() {
            return this.lenientSeparator;
        }

        public int getMaxCharsPerField() {
            return this.maxCharsPerField;
        }

        public boolean isValid() {
            return this.maxCharsPerField > 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Boolean.hashCode(this.lenientSeparator);
            hash = 37 * hash + this.maxCharsPerField;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReaderOptions other = (ReaderOptions)obj;
            if (this.lenientSeparator != other.lenientSeparator) {
                return false;
            }
            return this.maxCharsPerField == other.maxCharsPerField;
        }

        public String toString() {
            return "ReaderOptions(lenientSeparator=" + this.lenientSeparator + ", maxCharsPerField=" + this.maxCharsPerField + ')';
        }

        public Builder toBuilder() {
            return new Builder().lenientSeparator(this.lenientSeparator).maxCharsPerField(this.maxCharsPerField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private boolean lenientSeparator;
            private int maxCharsPerField;

            private Builder() {
            }

            public Builder lenientSeparator(boolean lenientSeparator) {
                this.lenientSeparator = lenientSeparator;
                return this;
            }

            public Builder maxCharsPerField(int maxCharsPerField) {
                this.maxCharsPerField = maxCharsPerField;
                return this;
            }

            public ReaderOptions build() {
                return new ReaderOptions(this.lenientSeparator, this.maxCharsPerField);
            }
        }
    }

    public static final class Format {
        public static final String WINDOWS_SEPARATOR = "\r\n";
        public static final String UNIX_SEPARATOR = "\n";
        public static final String MACINTOSH_SEPARATOR = "\r";
        private static final String DEFAULT_SEPARATOR = "\r\n";
        private static final char DEFAULT_DELIMITER = ',';
        private static final char DEFAULT_QUOTE = '\"';
        private static final char DEFAULT_COMMENT = '#';
        private static final boolean DEFAULT_ACCEPT_MISSING_FIELD = true;
        public static final Format RFC4180;
        public static final Format DEFAULT;
        private final String separator;
        private final char delimiter;
        private final char quote;
        private final char comment;
        private final boolean acceptMissingField;

        private Format(String separator, char delimiter, char quote, char comment, boolean acceptMissingField) {
            this.separator = Objects.requireNonNull(separator, "separator");
            this.delimiter = delimiter;
            this.quote = quote;
            this.comment = comment;
            this.acceptMissingField = acceptMissingField;
        }

        public String getSeparator() {
            return this.separator;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public char getQuote() {
            return this.quote;
        }

        public char getComment() {
            return this.comment;
        }

        public boolean isAcceptMissingField() {
            return this.acceptMissingField;
        }

        public boolean isValid() {
            return Format.hasValidSize(this.separator) && this.delimiter != this.quote && this.comment != this.delimiter && this.comment != this.quote && Format.doesNotContain(this.separator, this.delimiter) && Format.doesNotContain(this.separator, this.quote) && Format.doesNotContain(this.separator, this.comment);
        }

        private static boolean hasValidSize(String text) {
            int length = text.length();
            return 1 <= length && length < 3;
        }

        private static boolean doesNotContain(String text, char c) {
            return text.indexOf(c) == -1;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.separator);
            hash = 37 * hash + this.delimiter;
            hash = 37 * hash + this.quote;
            hash = 37 * hash + this.comment;
            hash = 37 * hash + (this.acceptMissingField ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Format other = (Format)obj;
            if (!this.separator.equals(other.separator)) {
                return false;
            }
            if (this.delimiter != other.delimiter) {
                return false;
            }
            if (this.quote != other.quote) {
                return false;
            }
            if (this.comment != other.comment) {
                return false;
            }
            return this.acceptMissingField == other.acceptMissingField;
        }

        public String toString() {
            return "Format(separator=" + Csv.prettyPrint(this.separator) + ", delimiter=" + Csv.prettyPrint(this.delimiter) + ", quote=" + Csv.prettyPrint(this.quote) + ", comment=" + Csv.prettyPrint(this.comment) + ", acceptMissingField=" + this.acceptMissingField + ')';
        }

        public Builder toBuilder() {
            return new Builder().separator(this.separator).delimiter(this.delimiter).quote(this.quote).comment(this.comment).acceptMissingField(this.acceptMissingField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        static {
            DEFAULT = RFC4180 = new Format("\r\n", ',', '\"', '#', true);
        }

        public static final class Builder {
            private String separator;
            private char delimiter;
            private char quote;
            private char comment;
            private boolean acceptMissingField;

            private Builder() {
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public Builder delimiter(char delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder quote(char quote) {
                this.quote = quote;
                return this;
            }

            public Builder comment(char comment) {
                this.comment = comment;
                return this;
            }

            public Builder acceptMissingField(boolean acceptMissingField) {
                this.acceptMissingField = acceptMissingField;
                return this;
            }

            public Format build() {
                return new Format(this.separator, this.delimiter, this.quote, this.comment, this.acceptMissingField);
            }
        }
    }
}

