/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.api.manapool.model.ProductItem;

public class InventoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @SerializedName(value="price_cents")
    private Integer priceCents;
    private Integer quantity;
    @SerializedName(value="effective_as_of")
    private String effectiveAsOf;
    @SerializedName(value="product_type")
    private String type;
    @SerializedName(value="product_id")
    private String productId;
    private ProductItem product;

    public double getPriceValue() {
        return this.getPriceCents() / 100;
    }

    public Date getDateffectiveAsOf() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").parse(this.effectiveAsOf);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String toString() {
        return this.getId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getPriceCents() {
        return this.priceCents;
    }

    public void setPriceCents(Integer priceCents) {
        this.priceCents = priceCents;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getEffectiveAsOf() {
        return this.effectiveAsOf;
    }

    public void setEffectiveAsOf(String effectiveAsOf) {
        this.effectiveAsOf = effectiveAsOf;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public ProductItem getProduct() {
        return this.product;
    }

    public void setProduct(ProductItem product) {
        this.product = product;
    }
}

