/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.tools;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.manapool.listener.URLCallInfo;
import org.api.manapool.listener.URLCallListener;

public class RestClient
implements Closeable {
    private final CloseableHttpClient httpClient;
    private final Gson gson;
    private final Map<String, String> defaultHeaders;
    protected Logger logger = LogManager.getLogger(this.getClass());
    private URLCallListener listener;

    public RestClient() {
        this(null, null);
    }

    public RestClient(String email, String token) {
        this.httpClient = HttpClients.createDefault();
        this.gson = new Gson();
        this.defaultHeaders = new HashMap<String, String>();
        if (email != null && token != null) {
            this.defaultHeaders.put("X-ManaPool-Email", email);
            this.defaultHeaders.put("X-ManaPool-Access-Token", token);
        }
        this.defaultHeaders.put("Content-Type", "application/json");
        this.defaultHeaders.put("Accept", "application/json");
    }

    public <T> T get(String url, Map<String, String> headers, Class<T> responseType) throws IOException {
        HttpGet request = new HttpGet("https://manapool.com/api/v1" + url);
        this.applyHeaders((HttpRequestBase)request, headers);
        return this.executeRequest((HttpUriRequest)request, responseType);
    }

    public <T> T post(String url, Object body, Map<String, String> headers, Class<T> responseType) throws IOException {
        HttpPost request = new HttpPost("https://manapool.com/api/v1" + url);
        this.applyHeaders((HttpRequestBase)request, headers);
        this.addJsonBody((HttpEntityEnclosingRequestBase)request, body);
        return this.executeRequest((HttpUriRequest)request, responseType);
    }

    public <T> T put(String url, Object body, Map<String, String> headers, Class<T> responseType) throws IOException {
        HttpPut request = new HttpPut("https://manapool.com/api/v1" + url);
        this.applyHeaders((HttpRequestBase)request, headers);
        this.addJsonBody((HttpEntityEnclosingRequestBase)request, body);
        return this.executeRequest((HttpUriRequest)request, responseType);
    }

    public <T> T delete(String url, Object body, Map<String, String> headers, Class<T> responseType) throws IOException {
        HttpDeleteWithBody request = new HttpDeleteWithBody("https://manapool.com/api/v1" + url);
        this.applyHeaders((HttpRequestBase)request, headers);
        if (body != null) {
            this.addJsonBody(request, body);
        }
        return this.executeRequest((HttpUriRequest)request, responseType);
    }

    private void applyHeaders(HttpRequestBase request, Map<String, String> headers) {
        this.defaultHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).setHeader(arg_0, arg_1));
        }
    }

    private void addJsonBody(HttpEntityEnclosingRequestBase request, Object body) {
        if (body != null) {
            String json = this.gson.toJson(body);
            this.logger.debug("body={}", (Object)json);
            request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        }
    }

    public <T> T fromJson(String json, Class<T> responseType) {
        return (T)this.gson.fromJson(json, responseType);
    }

    public void setCallListener(URLCallListener listener2) {
        this.listener = listener2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeRequest(HttpUriRequest request, Class<T> responseType) throws IOException {
        URLCallInfo callInfo = new URLCallInfo();
        try {
            CloseableHttpResponse response = this.httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            String jsonResponse = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null;
            this.logger.info("{} : {},", (Object)request, (Object)statusCode);
            callInfo.setEnd(Instant.now());
            callInfo.setUrl(request.getURI().toASCIIString());
            callInfo.setRequest(request);
            callInfo.setResponse((HttpResponse)response);
            if (statusCode < 200) throw new IOException(statusCode + " : " + jsonResponse);
            if (statusCode >= 300) throw new IOException(statusCode + " : " + jsonResponse);
            if (responseType == String.class) {
                T t = responseType.cast(jsonResponse);
                return t;
            }
            if (jsonResponse != null && !jsonResponse.isEmpty()) {
                try {
                    this.logger.debug("result: {},", (Object)jsonResponse);
                    T t = this.fromJson(jsonResponse, responseType);
                    return t;
                }
                catch (JsonSyntaxException e) {
                    throw new IOException("Erreur de parsing JSON : " + e.getMessage(), e);
                }
            }
            T t = null;
            return t;
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.notify(callInfo);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return "DELETE";
        }
    }
}

