/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.api.manapool.model.Inventory;
import org.api.manapool.model.InventoryItem;
import org.api.manapool.model.PriceVariation;
import org.api.manapool.model.ProductQueryEntry;
import org.api.manapool.tools.RestClient;

public class ManaPoolAPIService {
    private RestClient client;

    public ManaPoolAPIService(String email, String token) {
        this.client = new RestClient(email, token);
    }

    public ManaPoolAPIService(Properties p) {
        this.client = new RestClient(p.getProperty("EMAIL"), p.getProperty("TOKEN"));
    }

    public RestClient getClient() {
        return this.client;
    }

    public List<InventoryItem> getSellerInventory() throws IOException {
        return this.client.get("/seller/inventory", null, Inventory.class).getInventory();
    }

    public List<InventoryItem> getSellerInventory(int limit, int offset) throws IOException {
        return this.client.get("/seller/inventory?limit=" + limit + "&offset=" + offset, null, Inventory.class).getInventory();
    }

    public List<InventoryItem> addInventoryItems(List<ProductQueryEntry> inventoryList) throws IOException {
        return this.client.post("/seller/inventory/scryfall_id", inventoryList, null, Inventory.class).getInventory();
    }

    public InventoryItem updateInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.put("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryItem.class);
    }

    public InventoryItem deleteInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.delete("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryItem.class);
    }

    public List<PriceVariation> listSinglesPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/singles", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }

    public List<PriceVariation> listSealedPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/sealed", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }

    public List<PriceVariation> listVariantsPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/variants", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }
}

