/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.List;
import org.api.mkm.modele.Expansion;
import org.api.mkm.modele.Game;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Response;
import org.api.mkm.tools.Tools;

public class GameService {
    private XStream xstream = Tools.instNewXstream();
    private List<Game> games;

    public GameService() {
        this.xstream.addImplicitCollection(Response.class, "game", Game.class);
        this.xstream.addImplicitCollection(Response.class, "expansion", Expansion.class);
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
    }

    public Game getGame(int id) throws IOException {
        if (this.games == null) {
            this.games = this.listGames();
        }
        for (Game g : this.games) {
            if (g.getIdGame() != id) continue;
            return g;
        }
        return null;
    }

    public List<Game> listGames() throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/games";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        this.games = res.getGame();
        return this.games;
    }

    public List<Expansion> listExpansion(Integer id) throws IOException {
        Game g = new Game();
        g.setIdGame(id);
        return this.listExpansion(g);
    }

    public List<Expansion> listExpansion(Game g) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/games/" + g.getIdGame() + "/expansions";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getExpansion();
    }
}

