/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.modele.InsightElement;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class InsightService {
    private String url = "https://www.cardmarket.com/en/Magic/Data";
    private Logger logger = LogManager.getLogger(this.getClass());

    private List<InsightElement> parse(Elements trs) {
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double yesterdayPrice = this.parsePrice(((Element)tds.get(3)).text());
            double price = this.parsePrice(((Element)tds.get(5)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setUrl(productURL);
            table.setPrice(price);
            table.setYesterdayPrice(yesterdayPrice);
            table.setChangeValue((price - yesterdayPrice) / yesterdayPrice * 100.0);
            list.add(table);
        }
        return list;
    }

    private Elements getTableTrsFor(String url) throws IOException {
        this.logger.debug((Object)("reading " + url));
        Document doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31").get();
        return doc.select("table>tbody>tr");
    }

    private double parsePrice(String strprice) {
        try {
            strprice = strprice.substring(0, strprice.indexOf(32));
            strprice = strprice.replace(".", "");
            strprice = strprice.replace(',', '.');
            return Double.parseDouble(strprice);
        }
        catch (Exception e) {
            this.logger.error((Object)("error parsing " + strprice + " : " + e));
            return 0.0;
        }
    }

    public List<InsightElement> getTopCards(int interval) throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Top-Cards?interval=" + interval);
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double prices = this.parsePrice(((Element)tds.get(3)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setPrice(prices);
            table.setUrl(productURL);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getBestBargain() throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Best-Bargains");
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double prices = this.parsePrice(((Element)tds.get(3)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setPrice(prices);
            table.setUrl(productURL);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getHighestPercentStockReduction() throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Stock-Reduction");
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            int yesterdayStock = Integer.parseInt(((Element)tds.get(3)).text());
            int stock = Integer.parseInt(((Element)tds.get(5)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setUrl(productURL);
            table.setYesterdayStock(yesterdayStock);
            table.setStock(stock);
            table.setChangeValue(((double)stock - (double)yesterdayStock) / (double)yesterdayStock * 100.0);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getStartingPriceIncrease(boolean foil) throws IOException {
        String link = "/Starting-Price-Increse";
        if (foil) {
            link = "/Starting-Price-Increse-Foils";
        }
        Elements trs = this.getTableTrsFor(this.url + link);
        return this.parse(trs);
    }

    public List<InsightElement> getBiggestAvgSalesPriceIncrease(boolean foil) throws IOException {
        String link = "/Average-Sale-Price-Increase";
        if (foil) {
            link = "/Average-Sale-Price-Increase-Foils";
        }
        Elements trs = this.getTableTrsFor(this.url + link);
        return this.parse(trs);
    }
}

