/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.Game;
import org.api.mkm.modele.Inserted;
import org.api.mkm.modele.LightArticle;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Response;
import org.api.mkm.tools.Tools;

public class StockService {
    private XStream xstream;
    private Logger logger = LogManager.getLogger(this.getClass());

    public StockService() {
        this.xstream = Tools.instNewXstream();
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
        this.xstream.addImplicitCollection(Response.class, "lightArticles", LightArticle.class);
        this.xstream.addImplicitCollection(Response.class, "inserted", Inserted.class);
        this.xstream.addImplicitCollection(Response.class, "updatedArticles", Inserted.class);
    }

    public List<LightArticle> getStock(int idGame, String name) throws IOException {
        Game g = new Game();
        g.setIdGame(idGame);
        return this.getStock(g, name);
    }

    public List<LightArticle> getStock() throws IOException {
        return this.getStock(null, null);
    }

    public List<LightArticle> getStock(Game game, String name) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock";
        if (name != null) {
            link = link + "/" + URLEncoder.encode(name, "UTF-8");
        }
        if (game != null) {
            link = link + "/" + game.getIdGame();
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        xml = xml.replace("<article>", "<lightArticles>").replace("</article>", "</lightArticles>");
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getLightArticles();
    }

    public List<Article> getShoppingcartArticles() throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock/shoppingcart-articles";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getArticle();
    }

    public void exportStock(File f, Integer idGame) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock/file";
        if (idGame != null) {
            link = "https://api.cardmarket.com/ws/v2.0/stock/file?idGame=" + idGame;
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        byte[] bytes = Base64.decodeBase64((String)res.getPriceguidefile());
        File temp = new File("mkm_temp.gz");
        FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
        Tools.unzip(temp, f);
        if (!temp.delete()) {
            this.logger.error((Object)("couln't remove " + temp.getAbsolutePath()));
        }
    }

    public Inserted addArticle(Article a) throws IOException {
        return this.addArticles(List.of(a)).get(0);
    }

    public Inserted updateArticles(Article a) throws IOException {
        return this.updateArticles(List.of(a)).get(0);
    }

    public List<Inserted> updateArticles(List<Article> list) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request>");
        for (Article a : list) {
            temp.append("<article>");
            temp.append("<idProduct>").append(a.getIdProduct()).append("</idProduct>");
            temp.append("<idArticle>").append(a.getIdArticle()).append("</idArticle>");
            temp.append("<count>").append(a.getCount()).append("</count>");
            if (a.getLanguage() != null) {
                temp.append("<idLanguage>").append(a.getLanguage().getIdLanguage()).append("</idLanguage>");
            }
            if (a.getComments() != null) {
                temp.append("<comments>").append(a.getComments()).append("</comments>");
            }
            temp.append("<price>").append(a.getPrice()).append("</price>");
            temp.append("<condition>").append(a.getCondition()).append("</condition>");
            temp.append("<isFoil>").append(a.isFoil()).append("</isFoil>");
            temp.append("<isSigned>").append(a.isSigned()).append("</isSigned>");
            temp.append("<isPlayset>").append(a.isPlayset()).append("</isPlayset>");
            temp.append("</article>");
        }
        temp.append("</request>");
        String xml = Tools.getXMLResponse(link, "PUT", this.getClass(), temp.toString());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getUpdatedArticles();
    }

    public List<Inserted> addArticles(List<Article> list) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request>");
        for (Article a : list) {
            temp.append("<article>");
            temp.append("<idProduct>").append(a.getIdProduct()).append("</idProduct>");
            temp.append("<count>").append(a.getCount()).append("</count>");
            if (a.getLanguage() != null) {
                temp.append("<idLanguage>").append(a.getLanguage().getIdLanguage()).append("</idLanguage>");
            }
            if (a.getComments() != null) {
                temp.append("<comments>").append(a.getComments()).append("</comments>");
            }
            temp.append("<price>").append(a.getPrice()).append("</price>");
            temp.append("<condition>").append(a.getCondition()).append("</condition>");
            temp.append("<isFoil>").append(a.isFoil()).append("</isFoil>");
            temp.append("<isSigned>").append(a.isSigned()).append("</isSigned>");
            temp.append("<isPlayset>").append(a.isPlayset()).append("</isPlayset>");
            temp.append("</article>");
        }
        temp.append("</request>");
        String xml = Tools.getXMLResponse(link, "POST", this.getClass(), temp.toString());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getInserted();
    }

    public void removeArticle(Article a) throws IOException {
        this.removeArticles(List.of(a));
    }

    public void removeArticles(List<Article> list) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request>");
        for (Article a : list) {
            temp.append("<article>");
            temp.append("<idArticle>").append(a.getIdArticle()).append("</idArticle>");
            temp.append("<count>").append(a.getCount()).append("</count>");
            temp.append("</article>");
        }
        temp.append("</request>");
        Tools.getXMLResponse(link, "DELETE", this.getClass(), temp.toString());
    }

    public void exportStockFile(File f) throws IOException {
        this.exportStockFile(f, null);
    }

    public void exportStockFile(File f, Map<Article.ARTICLES_ATT, String> atts) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock/file";
        if (atts != null) {
            link = link + "?";
            ArrayList<String> paramStrings = new ArrayList<String>();
            for (Map.Entry<Article.ARTICLES_ATT, String> parameter : atts.entrySet()) {
                paramStrings.add((Object)((Object)parameter.getKey()) + "=" + parameter.getValue());
            }
            link = link + Tools.join(paramStrings, "&");
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        byte[] bytes = Base64.decodeBase64((String)res.getStock());
        File temp = new File("mkm_stock_temp.gz");
        FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
        Tools.unzip(temp, f);
        if (!temp.delete()) {
            this.logger.error((Object)("couldn't delete " + temp.getAbsolutePath()));
        }
    }

    public List<Article> getStockInShoppingCarts() throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock/shoppingcart-articles";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getArticle();
    }

    public void changeQte(LightArticle a, int qte) throws IOException {
        this.changeQte(List.of(a), qte);
    }

    public void changeQte(List<LightArticle> list, int qte) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/stock";
        link = qte > 0 ? link + "/increase" : link + "/decrease";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request>");
        for (LightArticle a : list) {
            temp.append("<article>");
            temp.append("<idArticle>").append(a.getIdArticle()).append("</idArticle>");
            temp.append("<amount>").append(Math.abs(qte)).append("</amount>");
            temp.append("</article>");
            a.setCount(a.getCount() + qte);
        }
        temp.append("</request>");
        Tools.getXMLResponse(link, "PUT", this.getClass(), temp.toString());
    }
}

