/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.List;
import org.api.mkm.exceptions.MkmException;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Response;
import org.api.mkm.modele.Thread;
import org.api.mkm.modele.User;
import org.api.mkm.tools.Tools;

public class UserService {
    private XStream xstream = Tools.instNewXstream();

    public UserService() {
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
        this.xstream.addImplicitCollection(Response.class, "thread", Thread.class);
        this.xstream.addImplicitCollection(Response.class, "users", User.class);
        this.xstream.addImplicitCollection(Thread.class, "links", Link.class);
    }

    public List<User> findUsers(String name) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/users/find?search=" + name.toLowerCase();
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        if (res.getErrors() != null) {
            throw new MkmException(res.getErrors());
        }
        return res.getUsers();
    }

    public boolean setVacation(boolean vacation) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/account?onVacation=" + vacation;
        Tools.getXMLResponse(link, "PUT", this.getClass());
        return true;
    }

    public boolean sendMessage(User u, String message) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/account/messages/" + u.getIdUser();
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request><message>" + message + "</message>");
        temp.append("</request>");
        Tools.getXMLResponse(link, "POST", this.getClass(), temp.toString());
        return true;
    }

    public List<Thread> getMessages(User other) throws IOException {
        Object link = "https://api.cardmarket.com/ws/v2.0/account/messages";
        if (other != null) {
            link = (String)link + "/" + other.getIdUser();
        }
        String xml = Tools.getXMLResponse((String)link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getThread();
    }
}

