/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.api.mkm.modele.LightArticle;
import org.api.mkm.services.StockService;
import org.mkm.gui.modeles.LightArticlesTableModel;

public class MKMStockPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable tableArticles;
    private LightArticlesTableModel articlesModel;

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel();
        this.add((Component)panelNorth, "North");
        JButton btnLoadStock = new JButton("Load Stock");
        btnLoadStock.addActionListener(ae -> {
            StockService serv = new StockService();
            try {
                this.articlesModel.init(serv.getStock());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        panelNorth.add(btnLoadStock);
        JButton btnDownQte = new JButton("-");
        btnDownQte.addActionListener(ae -> {
            LightArticle a = (LightArticle)this.tableArticles.getValueAt(this.tableArticles.getSelectedRow(), 0);
            StockService serv = new StockService();
            try {
                serv.changeQte(a, -1);
                this.articlesModel.fireTableDataChanged();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
            }
        });
        panelNorth.add(btnDownQte);
        JButton btnUpQte = new JButton("+");
        btnUpQte.addActionListener(ae -> {
            LightArticle a = (LightArticle)this.tableArticles.getValueAt(this.tableArticles.getSelectedRow(), 0);
            StockService serv = new StockService();
            try {
                serv.changeQte(a, 1);
                this.articlesModel.fireTableDataChanged();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
            }
        });
        panelNorth.add(btnUpQte);
        JScrollPane panelCenter = new JScrollPane();
        this.add((Component)panelCenter, "Center");
        this.articlesModel = new LightArticlesTableModel();
        this.tableArticles = new JTable(this.articlesModel);
        panelCenter.setViewportView(this.tableArticles);
    }

    public MKMStockPanel() {
        this.initGUI();
    }
}

