/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.Localization;
import org.api.mkm.modele.Product;
import org.api.mkm.modele.WantItem;
import org.api.mkm.modele.Wantslist;
import org.api.mkm.services.ArticleService;
import org.api.mkm.services.CartServices;
import org.api.mkm.services.ProductServices;
import org.api.mkm.services.StockService;
import org.api.mkm.services.WantsService;
import org.mkm.gui.JWantListChooser;
import org.mkm.gui.modeles.ArticlesTableModel;
import org.mkm.gui.renderer.ProductListRenderer;

public class MkmSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JList<Product> listResults;
    private JTable tableArticles;
    private DefaultListModel<Product> productsModel;
    private ArticlesTableModel articlesModel;
    private transient Logger logger = LogManager.getLogger(this.getClass());
    private JLabel lblPics;
    private JButton btnAddWantlist;
    private JButton btnBasket;
    private JButton btnAddStock;
    private Product selectedProduct;
    private Article selectedArticle;

    private void initGUI() {
        this.lblPics = new JLabel();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.lblPics, "East");
        JPanel panelNorth = new JPanel();
        this.add((Component)panelNorth, "North");
        JTextField txtSearch = new JTextField();
        txtSearch.addActionListener(ae -> this.search(txtSearch.getText()));
        JLabel lblSearchProduct = new JLabel("Search product : ");
        panelNorth.add(lblSearchProduct);
        panelNorth.add(txtSearch);
        txtSearch.setColumns(15);
        this.btnAddWantlist = new JButton("Add WantList");
        this.btnAddWantlist.addActionListener(ae -> {
            try {
                JWantListChooser choose = new JWantListChooser();
                choose.setVisible(true);
                Wantslist l = choose.getSelected();
                WantsService service = new WantsService();
                WantItem it = new WantItem();
                it.setProduct(this.selectedProduct);
                it.setCount(1);
                service.addItem(l, it);
            }
            catch (Exception e1) {
                this.logger.error((Object)e1);
            }
        });
        panelNorth.add(new JLabel("or by id :"));
        JTextField txtID = new JTextField();
        txtID.addActionListener(ae -> this.search(Integer.parseInt(txtID.getText())));
        panelNorth.add(txtID);
        txtID.setColumns(10);
        this.btnAddWantlist.setEnabled(false);
        panelNorth.add(this.btnAddWantlist);
        this.btnAddStock = new JButton("add to Stock");
        panelNorth.add(this.btnAddStock);
        this.btnAddStock.addActionListener(l -> {
            StockService serv = new StockService();
            List<Product> pdts = this.listResults.getSelectedValuesList();
            ArrayList<Article> arts = new ArrayList<Article>();
            for (Product p : pdts) {
                Article a = new Article();
                a.setProduct(p);
                a.setIdProduct(p.getIdProduct());
                a.setComments("Import from mkm ui");
                a.setPrice(1000000.0);
                a.setCount(1);
                a.setLanguage(new Localization(1, "English"));
                a.setCondition("NM");
                arts.add(a);
            }
            try {
                serv.addArticles(arts);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        this.btnBasket = new JButton("add to Basket");
        this.btnBasket.addActionListener(ae -> {
            CartServices serv = new CartServices();
            try {
                serv.addArticle(this.selectedArticle);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        this.btnBasket.setEnabled(false);
        panelNorth.add(this.btnBasket);
        JButton btnExportProduct = new JButton("Export Product Catalog");
        btnExportProduct.addActionListener(ae -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Choose Location");
            int userSelection = fileChooser.showSaveDialog(null);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                ProductServices services = new ProductServices();
                try {
                    services.exportProductList(fileToSave);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e, "ERROR", 0);
                }
            }
        });
        JButton btnExportPriceGuid = new JButton("Export PriceGuide");
        btnExportPriceGuid.addActionListener(ae -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Choose Location");
            int userSelection = fileChooser.showSaveDialog(null);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                ProductServices services = new ProductServices();
                try {
                    services.exportPriceGuide(fileToSave, 1);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e, "ERROR", 0);
                }
            }
        });
        panelNorth.add(btnExportPriceGuid);
        panelNorth.add(btnExportProduct);
        JScrollPane panelWest = new JScrollPane();
        this.add((Component)panelWest, "West");
        this.productsModel = new DefaultListModel();
        this.listResults = new JList<Product>(this.productsModel);
        this.listResults.setCellRenderer(new ProductListRenderer());
        this.listResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MkmSearchPanel.this.btnAddWantlist.setEnabled(true);
                MkmSearchPanel.this.loadArticle(MkmSearchPanel.this.listResults.getSelectedValue());
                try {
                    MkmSearchPanel.this.selectedProduct = MkmSearchPanel.this.listResults.getSelectedValue();
                    URL url = new URL("https:" + MkmSearchPanel.this.selectedProduct.getImage());
                    BufferedImage im = ImageIO.read(url);
                    MkmSearchPanel.this.lblPics.setIcon(new ImageIcon(im));
                }
                catch (Exception e) {
                    MkmSearchPanel.this.logger.error((Object)("https:" + MkmSearchPanel.this.selectedProduct.getImage()), (Throwable)e);
                }
            }
        });
        panelWest.setViewportView(this.listResults);
        JScrollPane panelCenter = new JScrollPane();
        this.add((Component)panelCenter, "Center");
        this.articlesModel = new ArticlesTableModel();
        this.tableArticles = new JTable(this.articlesModel);
        this.tableArticles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MkmSearchPanel.this.btnBasket.setEnabled(true);
                MkmSearchPanel.this.selectedArticle = (Article)MkmSearchPanel.this.articlesModel.getValueAt(MkmSearchPanel.this.tableArticles.getSelectedRow(), 0);
            }
        });
        panelCenter.setViewportView(this.tableArticles);
    }

    protected void search(String text) {
        ProductServices services = new ProductServices();
        EnumMap<Product.PRODUCT_ATTS, String> map = new EnumMap<Product.PRODUCT_ATTS, String>(Product.PRODUCT_ATTS.class);
        try {
            this.productsModel.removeAllElements();
            List<Product> prods = services.findProduct(text, map);
            for (Product p : prods) {
                this.productsModel.addElement(p);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error searching", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    protected void search(int id) {
        ProductServices services = new ProductServices();
        try {
            this.productsModel.removeAllElements();
            Product p = services.getProductById(id);
            this.productsModel.addElement(p);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    public MkmSearchPanel() {
        this.initGUI();
    }

    protected void loadArticle(Product selectedValue) {
        ArticleService service = new ArticleService();
        EnumMap<Article.ARTICLES_ATT, String> atts = new EnumMap<Article.ARTICLES_ATT, String>(Article.ARTICLES_ATT.class);
        atts.put(Article.ARTICLES_ATT.start, "0");
        atts.put(Article.ARTICLES_ATT.maxResults, "100");
        try {
            this.articlesModel.init(service.find(selectedValue, atts));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }
}

