/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Product;
import org.api.mkm.modele.Response;
import org.api.mkm.modele.User;
import org.api.mkm.tools.Tools;

public class ArticleService {
    private XStream xstream = Tools.instNewXstream();

    public ArticleService() {
        this.xstream.addImplicitCollection(Response.class, "article", Article.class);
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
    }

    public List<Article> find(User u, Map<Article.ARTICLES_ATT, String> atts) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/users/" + u.getUsername() + "/articles";
        if (atts != null && atts.size() > 0) {
            link = link + "?";
            ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
            for (Map.Entry<Article.ARTICLES_ATT, String> parameter : atts.entrySet()) {
                paramStrings.add((CallSite)((Object)((Object)((Object)parameter.getKey()) + "=" + parameter.getValue())));
            }
            link = link + Tools.join(paramStrings, "&");
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getArticle();
    }

    public List<Article> find(Product p, Map<Article.ARTICLES_ATT, String> atts) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/articles/" + p.getIdProduct();
        if (atts != null && atts.size() > 0) {
            link = link + "?";
            ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
            for (Map.Entry<Article.ARTICLES_ATT, String> parameter : atts.entrySet()) {
                paramStrings.add((CallSite)((Object)((Object)((Object)parameter.getKey()) + "=" + parameter.getValue())));
            }
            link = link + Tools.join(paramStrings, "&");
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        try {
            Response res = (Response)this.xstream.fromXML(xml);
            for (Article a : res.getArticle()) {
                a.setProduct(p);
            }
            return res.getArticle();
        }
        catch (Exception e) {
            return new ArrayList<Article>();
        }
    }
}

