/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.api.mkm.modele.LightArticle;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Order;
import org.api.mkm.modele.Response;
import org.api.mkm.tools.Tools;

public class OrderService {
    private XStream xstream = Tools.instNewXstream();

    public OrderService() {
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
        this.xstream.addImplicitCollection(Response.class, "order", Order.class);
        this.xstream.addImplicitCollection(Order.class, "article", LightArticle.class);
    }

    public List<Order> listOrders(File f) throws IOException {
        String xml = Files.readString(f.toPath());
        Response res = (Response)this.xstream.fromXML(xml);
        if (this.isEmpty(res.getOrder())) {
            return new ArrayList<Order>();
        }
        return res.getOrder();
    }

    public List<Order> listOrders(ACTOR a, STATE s, Integer min) throws IOException {
        String xml;
        Response res;
        Object link = "https://api.cardmarket.com/ws/v2.0/orders/:actor/:state";
        link = ((String)link).replace(":actor", a.name());
        link = ((String)link).replace(":state", s.name());
        if (min != null) {
            link = (String)link + "/" + min;
        }
        if (this.isEmpty((res = (Response)this.xstream.fromXML(xml = Tools.getXMLResponse((String)link, "GET", this.getClass()))).getOrder())) {
            return new ArrayList<Order>();
        }
        return res.getOrder();
    }

    public Order getOrderById(int id) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/order/" + id;
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getOrder().get(0);
    }

    public void putTrackingNumber(int idOrder, String number) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/order/" + idOrder + "/tracking";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request>");
        temp.append("<trackingNumber>").append(number).append("</trackingNumber>");
        temp.append("</request>");
        Tools.getXMLResponse(link, "PUT", this.getClass(), temp.toString());
    }

    public boolean isEmpty(List<Order> orders) {
        return orders.get(0).getIdOrder() == 0;
    }

    public static enum ACTOR {
        seller,
        buyer;

    }

    public static enum STATE {
        bought,
        paid,
        sent,
        received,
        lost,
        cancelled;

    }
}

