/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.modele.InsightElement;
import org.api.mkm.modele.Product;
import org.api.mkm.tools.Tools;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class InsightService {
    private String url = "https://www.cardmarket.com/en/Magic/Data";
    private Logger logger = LogManager.getLogger(this.getClass());

    private List<InsightElement> parse(Elements trs) {
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double yesterdayPrice = this.parsePrice(((Element)tds.get(3)).text());
            double price = this.parsePrice(((Element)tds.get(5)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setUrl(productURL);
            table.setPrice(price);
            table.setYesterdayPrice(yesterdayPrice);
            table.setChangeValue((price - yesterdayPrice) / yesterdayPrice * 100.0);
            list.add(table);
        }
        return list;
    }

    private Elements getTableTrsFor(String url) throws IOException {
        this.logger.debug("reading " + url);
        Document doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31").get();
        return doc.select("table>tbody>tr");
    }

    private double parsePrice(String strprice) {
        try {
            strprice = strprice.substring(0, strprice.indexOf(32));
            strprice = strprice.replace(".", "");
            strprice = strprice.replace(',', '.');
            return Double.parseDouble(strprice);
        }
        catch (Exception e) {
            this.logger.error("error parsing " + strprice + " : " + String.valueOf(e));
            return 0.0;
        }
    }

    public List<InsightElement> getTopCards(int interval) throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Top-Cards?interval=" + interval);
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double prices = this.parsePrice(((Element)tds.get(3)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setPrice(prices);
            table.setUrl(productURL);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getBestBargain() throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Best-Bargains");
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            double prices = this.parsePrice(((Element)tds.get(3)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setPrice(prices);
            table.setUrl(productURL);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getHighestPercentStockReduction() throws IOException {
        Elements trs = this.getTableTrsFor(this.url + "/Stock-Reduction");
        ArrayList<InsightElement> list = new ArrayList<InsightElement>();
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            InsightElement table = new InsightElement();
            String edition = ((Element)tds.get(1)).select("span").attr("title");
            String productURL = "https://www.cardmarket.com" + ((Element)tds.get(2)).select("a").attr("href");
            String productName = ((Element)tds.get(2)).select("a").text();
            int yesterdayStock = Integer.parseInt(((Element)tds.get(3)).text());
            int stock = Integer.parseInt(((Element)tds.get(5)).text());
            table.setCardName(productName);
            table.setEd(edition);
            table.setUrl(productURL);
            table.setYesterdayStock(yesterdayStock);
            table.setStock(stock);
            table.setChangeValue(((double)stock - (double)yesterdayStock) / (double)yesterdayStock * 100.0);
            list.add(table);
        }
        return list;
    }

    public List<InsightElement> getStartingPriceIncrease(boolean foil) throws IOException {
        String link = "/Starting-Price-Increse";
        if (foil) {
            link = "/Starting-Price-Increse-Foils";
        }
        Elements trs = this.getTableTrsFor(this.url + link);
        return this.parse(trs);
    }

    public List<InsightElement> getBiggestAvgSalesPriceIncrease(boolean foil) throws IOException {
        String link = "/Average-Sale-Price-Increase";
        if (foil) {
            link = "/Average-Sale-Price-Increase-Foils";
        }
        Elements trs = this.getTableTrsFor(this.url + link);
        return this.parse(trs);
    }

    public Map<Date, Double> priceHistory(Product p, boolean foil) throws IOException {
        HashMap<Date, Double> ret = new HashMap<Date, Double>();
        String url = "https://www.cardmarket.com/" + p.getWebsite() + "?isFoil=" + (foil ? "Y" : "N");
        Element d = Tools.getDocument(url).select("script.chart-init-script").first();
        Object toParse = d.html();
        toParse = ((String)toParse).substring(((String)toParse).indexOf("{\"type\""), ((String)toParse).indexOf("\"options\"") - 1) + "}";
        JsonElement el = JsonParser.parseString((String)toParse);
        JsonArray dates = el.getAsJsonObject().get("data").getAsJsonObject().get("labels").getAsJsonArray();
        JsonArray values = el.getAsJsonObject().get("data").getAsJsonObject().get("datasets").getAsJsonArray().get(0).getAsJsonObject().get("data").getAsJsonArray();
        for (int i = 0; i < dates.size(); ++i) {
            try {
                ret.put(new SimpleDateFormat("dd.MM.yyyy").parse(dates.get(i).getAsString()), values.get(i).getAsDouble());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (ParseException e) {
                this.logger.error("Error parsing " + dates.get(i).getAsString(), (Throwable)e);
            }
        }
        return ret;
    }
}

