/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui.modeles;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.api.mkm.modele.LightArticle;

public class LightArticlesTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columns = new String[]{"product", "expansion", "price", "condition", "foil", "signed", "playset", "altered", "comments", "count", "LocationName", "Language", "idArticle", "idProduct"};
    private List<LightArticle> articles;

    public void init(List<LightArticle> articles) {
        this.articles = articles;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        if (this.articles == null) {
            return 0;
        }
        return this.articles.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        LightArticle a = this.articles.get(row);
        switch (column) {
            case 0: {
                return a;
            }
            case 1: {
                return a.getProduct().getExpansion();
            }
            case 2: {
                return a.getPrice();
            }
            case 3: {
                return a.getCondition();
            }
            case 4: {
                return a.isFoil();
            }
            case 5: {
                return a.isSigned();
            }
            case 6: {
                return a.isPlayset();
            }
            case 7: {
                return a.isAltered();
            }
            case 8: {
                return a.getComments();
            }
            case 9: {
                return a.getCount();
            }
            case 10: {
                return a.getProduct().getLocName();
            }
            case 11: {
                return a.getLanguage().getLanguageName();
            }
            case 12: {
                return a.getIdArticle();
            }
            case 13: {
                return a.getIdProduct();
            }
        }
        return 0;
    }
}

