/*
 * Decompiled with CFR 0.152.
 */
package com.github.nill14.shellformat;

import com.github.nill14.shellformat.ShellFormat;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class ShellDictionary {
    private final Map<String, Object> dictionary = new HashMap<String, Object>();

    private ShellDictionary() {
    }

    static ShellDictionary dictionary(String ... arguments) {
        ShellDictionary dict = new ShellDictionary();
        dict.appendAll(arguments);
        return dict;
    }

    public Map<String, Object> toMap() {
        return ImmutableMap.copyOf(this.dictionary);
    }

    public ShellFormat compile() {
        return new ShellFormat(this.toMap());
    }

    public String format(String pattern) {
        return new ShellFormat(this.toMap()).format(pattern);
    }

    public String format(String ... lines) {
        return new ShellFormat(this.toMap()).format(lines);
    }

    public ShellDictionary appendAll(String ... strings) {
        if (strings.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of parameters: " + strings.length);
        }
        for (int i = 0; i < strings.length; i += 2) {
            this.dictionary.put(strings[i], strings[i + 1]);
        }
        return this;
    }

    public ShellDictionary append(String alias, Object value) {
        this.dictionary.put(alias, value);
        return this;
    }
}

