/*
 * Decompiled with CFR 0.152.
 */
package com.github.nill14.utils.exception;

import java.util.NoSuchElementException;

public enum StackTraceParser {


    public static String getCalledMethod(int level) {
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        int index = StackTraceParser.findNthFilename(stackTrace, level);
        String methodName = stackTrace[index - 1].getMethodName();
        String callerReference = StackTraceParser.formatReference(stackTrace[index]);
        return String.format("%s: %s() ", callerReference, methodName);
    }

    public static String formatReference(StackTraceElement element) {
        String filename = element.getFileName();
        int lineNumber = element.getLineNumber();
        if (filename != null && lineNumber >= 0) {
            return String.format("(%s:%d)", filename, lineNumber);
        }
        if (filename != null) {
            return String.format("(%s)", filename);
        }
        return "(Unknown Source)";
    }

    public static int findNthFilename(StackTraceElement[] stackTrace, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException(String.format("Level = %s, expected >= 1", level));
        }
        if (level >= stackTrace.length) {
            throw new IllegalArgumentException("Level is far too big");
        }
        int index = -1;
        String classname = null;
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (classname != null && classname.equals(element.getClassName())) continue;
            classname = element.getClassName();
            if (++index != level) continue;
            return i;
        }
        throw new NoSuchElementException(String.format("The last level was %d, requested %d", index, level));
    }
}

