/*
 * Decompiled with CFR 0.152.
 */
package com.github.oohira.intercom.model;

import java.util.List;

public class ErrorResponse {
    private static final String TYPE_ERROR_LIST = "error.list";
    private String type;
    private Error error;
    private List<Error> errors;
    private transient int statusCode;

    public boolean isErrorList() {
        return TYPE_ERROR_LIST.equals(this.type);
    }

    public Error getError() {
        if (this.isErrorList()) {
            throw new UnsupportedOperationException("This is an Error List object. Use getErrors() instead.");
        }
        return this.error;
    }

    public List<Error> getErrors() {
        if (!this.isErrorList()) {
            throw new UnsupportedOperationException("This is a single Error object. Use getError() instead.");
        }
        return this.errors;
    }

    public String getType() {
        if (this.isErrorList()) {
            if (this.errors != null && !this.errors.isEmpty()) {
                return this.errors.get(0).getCode();
            }
        } else if (this.error != null) {
            return this.error.getType();
        }
        return null;
    }

    public String getMessage() {
        if (this.isErrorList()) {
            if (this.errors != null && !this.errors.isEmpty()) {
                return this.errors.get(0).getMessage();
            }
        } else if (this.error != null) {
            return this.error.getMessage();
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public static class Error {
        private String type;
        private String code;
        private String message;

        public String getType() {
            return this.type;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

