/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser;

import com.github.pagehelper.parser.SqlParser;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;

public class TimeoutSqlParser
implements SqlParser {
    ExecutorService executorService = Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors() * 2);

    public Statement parse(String sql) throws JSQLParserException {
        CCJSqlParser parser = CCJSqlParserUtil.newParser((String)sql);
        parser.withSquareBracketQuotation(true);
        Future<Statement> future = this.executorService.submit(() -> parser.Statement());
        try {
            Statement statement = future.get(100000L, TimeUnit.MILLISECONDS);
            return statement;
        }
        catch (TimeoutException var5) {
            parser.interrupted = true;
            future.cancel(true);
            throw new JSQLParserException("Time out occurred.", (Throwable)var5);
        }
        catch (Exception var6) {
            throw new JSQLParserException((Throwable)var6);
        }
    }
}

