/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot;

import com.google.gson.Gson;
import com.pengrad.telegrambot.impl.BotApi;
import com.pengrad.telegrambot.impl.FileApi;
import com.pengrad.telegrambot.model.File;
import com.pengrad.telegrambot.model.request.ChatAction;
import com.pengrad.telegrambot.model.request.InlineQueryResult;
import com.pengrad.telegrambot.model.request.InputFile;
import com.pengrad.telegrambot.model.request.InputFileBytes;
import com.pengrad.telegrambot.model.request.Keyboard;
import com.pengrad.telegrambot.model.request.ParseMode;
import com.pengrad.telegrambot.response.GetFileResponse;
import com.pengrad.telegrambot.response.GetMeResponse;
import com.pengrad.telegrambot.response.GetUpdatesResponse;
import com.pengrad.telegrambot.response.GetUserProfilePhotosResponse;
import com.pengrad.telegrambot.response.OkResponse;
import com.pengrad.telegrambot.response.SendChatActionResponse;
import com.pengrad.telegrambot.response.SendResponse;
import com.pengrad.telegrambot.response.SetWebhookResponse;

public class TelegramBot {
    private final BotApi botApi;
    private final FileApi fileApi;
    private final Gson gson;

    public TelegramBot(BotApi botApi, FileApi fileApi) {
        this.botApi = botApi;
        this.fileApi = fileApi;
        this.gson = new Gson();
    }

    public String getFullFilePath(String fileId) {
        GetFileResponse fileResponse = this.botApi.getFile(fileId);
        if (!fileResponse.isOk() || fileResponse.file() == null) {
            return null;
        }
        return this.fileApi.getFullFilePath(fileResponse.file().filePath());
    }

    public String getFullFilePath(File file) {
        return this.fileApi.getFullFilePath(file.filePath());
    }

    public GetMeResponse getMe() {
        return this.botApi.getMe();
    }

    public SendResponse sendMessage(Object chatId, String text) {
        return this.botApi.sendMessage(String.valueOf(chatId), text, null, null, null, null);
    }

    public SendResponse sendMessage(Object chatId, String text, ParseMode parse_mode, Boolean disableWebPagePreview, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendMessage(String.valueOf(chatId), text, parse_mode, disableWebPagePreview, replyToMessageId, replyMarkup);
    }

    public SendResponse forwardMessage(Object chatId, Object fromChatId, Integer messageId) {
        return this.botApi.forwardMessage(String.valueOf(chatId), String.valueOf(fromChatId), messageId);
    }

    public SendResponse sendPhoto(Object chatId, String photo, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendPhoto(String.valueOf(chatId), photo, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendPhoto(Object chatId, InputFile photo, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendPhoto(String.valueOf(chatId), photo, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendPhoto(Object chatId, InputFileBytes photo, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendPhoto(String.valueOf(chatId), photo, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendAudio(Object chatId, String audio, Integer duration, String performer, String title, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendAudio(String.valueOf(chatId), audio, duration, performer, title, replyToMessageId, replyMarkup);
    }

    public SendResponse sendAudio(Object chatId, InputFile audio, Integer duration, String performer, String title, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendAudio(String.valueOf(chatId), audio, duration, performer, title, replyToMessageId, replyMarkup);
    }

    public SendResponse sendAudio(Object chatId, InputFileBytes audio, Integer duration, String performer, String title, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendAudio(String.valueOf(chatId), audio, duration, performer, title, replyToMessageId, replyMarkup);
    }

    public SendResponse sendDocument(Object chatId, String document, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendDocument(String.valueOf(chatId), document, replyToMessageId, replyMarkup);
    }

    public SendResponse sendDocument(Object chatId, InputFile document, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendDocument(String.valueOf(chatId), document, replyToMessageId, replyMarkup);
    }

    public SendResponse sendDocument(Object chatId, InputFileBytes document, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendDocument(String.valueOf(chatId), document, replyToMessageId, replyMarkup);
    }

    public SendResponse sendSticker(Object chatId, String sticker, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendSticker(String.valueOf(chatId), sticker, replyToMessageId, replyMarkup);
    }

    public SendResponse sendSticker(Object chatId, InputFile sticker, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendSticker(String.valueOf(chatId), sticker, replyToMessageId, replyMarkup);
    }

    public SendResponse sendSticker(Object chatId, InputFileBytes sticker, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendSticker(String.valueOf(chatId), sticker, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVideo(Object chatId, String video, Integer duration, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVideo(String.valueOf(chatId), video, duration, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVideo(Object chatId, InputFile video, Integer duration, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVideo(String.valueOf(chatId), video, duration, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVideo(Object chatId, InputFileBytes video, Integer duration, String caption, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVideo(String.valueOf(chatId), video, duration, caption, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVoice(Object chatId, String voice, Integer duration, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVoice(String.valueOf(chatId), voice, duration, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVoice(Object chatId, InputFile voice, Integer duration, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVoice(String.valueOf(chatId), voice, duration, replyToMessageId, replyMarkup);
    }

    public SendResponse sendVoice(Object chatId, InputFileBytes voice, Integer duration, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendVoice(String.valueOf(chatId), voice, duration, replyToMessageId, replyMarkup);
    }

    public SendResponse sendLocation(Object chatId, Float latitude, Float longitude, Integer replyToMessageId, Keyboard replyMarkup) {
        return this.botApi.sendLocation(String.valueOf(chatId), latitude, longitude, replyToMessageId, replyMarkup);
    }

    public SendChatActionResponse sendChatAction(Object chatId, ChatAction action) {
        return this.botApi.sendChatAction(String.valueOf(chatId), action);
    }

    public GetUserProfilePhotosResponse getUserProfilePhotos(Integer userId, Integer offset, Integer limit) {
        return this.botApi.getUserProfilePhotos(userId, offset, limit);
    }

    public GetUpdatesResponse getUpdates(Integer offset, Integer limit, Integer timeout) {
        return this.botApi.getUpdates(offset, limit, timeout);
    }

    public SetWebhookResponse setWebhook(String url) {
        return this.botApi.setWebhook(url);
    }

    public SetWebhookResponse setWebhook(String url, InputFile certificate) {
        return this.botApi.setWebhook(url, certificate);
    }

    public SetWebhookResponse setWebhook(String url, InputFileBytes certificate) {
        return this.botApi.setWebhook(url, certificate);
    }

    public GetFileResponse getFile(String fileId) {
        return this.botApi.getFile(fileId);
    }

    public OkResponse answerInlineQuery(String inlineQueryId, InlineQueryResult ... results) {
        return this.answerInlineQuery(inlineQueryId, results, (Integer)null, (Boolean)null, (String)null);
    }

    public OkResponse answerInlineQuery(String inlineQueryId, InlineQueryResult[] results, Integer cacheTime, Boolean isPersonal, String nextOffset) {
        return this.botApi.answerInlineQuery(inlineQueryId, this.gson.toJson((Object)results), cacheTime, isPersonal, nextOffset);
    }
}

