/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot;

import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.impl.BotApi;
import com.pengrad.telegrambot.impl.FileApi;
import retrofit.RestAdapter;

public class TelegramBotAdapter {
    public static final String API_URL = "https://api.telegram.org/bot";

    public static TelegramBot build(String botToken) {
        RestAdapter restAdapter = TelegramBotAdapter.prepare(botToken).build();
        BotApi botApi = (BotApi)restAdapter.create(BotApi.class);
        FileApi fileApi = new FileApi(botToken);
        return new TelegramBot(botApi, fileApi);
    }

    public static TelegramBot buildDebug(String botToken) {
        RestAdapter restAdapter = TelegramBotAdapter.prepare(botToken).setLogLevel(RestAdapter.LogLevel.FULL).build();
        BotApi botApi = (BotApi)restAdapter.create(BotApi.class);
        FileApi fileApi = new FileApi(botToken);
        return new TelegramBot(botApi, fileApi);
    }

    public static RestAdapter.Builder prepare(String botToken) {
        return new RestAdapter.Builder().setEndpoint(API_URL + botToken);
    }
}

