/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.google.gson.Gson;
import com.pengrad.telegrambot.response.BaseResponse;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRequest<T extends BaseRequest, R extends BaseResponse> {
    private static final Gson gson = new Gson();
    protected final T thisAsT = this;
    private final Class<? extends R> responseClass;
    private final Map<String, Object> parameters;

    public BaseRequest(Class<? extends R> responseClass) {
        this.responseClass = responseClass;
        this.parameters = new HashMap<String, Object>();
    }

    protected T add(String name, Object val) {
        this.parameters.put(name, val);
        return this.thisAsT;
    }

    public String getMethod() {
        String className = this.getClass().getSimpleName();
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Type getResponseType() {
        return this.responseClass;
    }

    public boolean isMultipart() {
        return false;
    }

    public String getFileName() {
        return "file.txt";
    }

    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    public int getTimeoutSeconds() {
        return 0;
    }

    protected String serialize(Object o) {
        return gson.toJson(o);
    }
}

