/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.impl;

import com.google.gson.Gson;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.BaseResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TelegramBotClient {
    private final OkHttpClient client;
    private OkHttpClient clientWithTimeout;
    private final Gson gson;
    private final String baseUrl;

    public TelegramBotClient(OkHttpClient client, Gson gson, String baseUrl) {
        this.client = client;
        this.gson = gson;
        this.baseUrl = baseUrl;
        this.clientWithTimeout = client;
    }

    public <T extends BaseRequest, R extends BaseResponse> void send(final T request, final Callback<T, R> callback) {
        OkHttpClient client = this.getOkHttpClient(request);
        client.newCall(this.createRequest(request)).enqueue(new okhttp3.Callback(){

            public void onResponse(Call call, Response response) {
                BaseResponse result = null;
                Exception exception = null;
                try {
                    result = (BaseResponse)TelegramBotClient.this.gson.fromJson(response.body().string(), request.getResponseType());
                }
                catch (Exception e) {
                    exception = e;
                }
                if (result != null) {
                    callback.onResponse(request, result);
                } else if (exception != null) {
                    IOException ioEx = exception instanceof IOException ? (IOException)exception : new IOException(exception);
                    callback.onFailure(request, ioEx);
                } else {
                    callback.onFailure(request, new IOException("Empty response"));
                }
            }

            public void onFailure(Call call, IOException e) {
                callback.onFailure(request, e);
            }
        });
    }

    public <T extends BaseRequest, R extends BaseResponse> R send(BaseRequest<T, R> request) {
        try {
            OkHttpClient client = this.getOkHttpClient(request);
            Response response = client.newCall(this.createRequest(request)).execute();
            return (R)((BaseResponse)this.gson.fromJson(response.body().string(), request.getResponseType()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OkHttpClient getOkHttpClient(BaseRequest request) {
        int timeoutMillis = request.getTimeoutSeconds() * 1000;
        if (this.client.readTimeoutMillis() == 0 || this.client.readTimeoutMillis() > timeoutMillis) {
            return this.client;
        }
        if (this.clientWithTimeout.readTimeoutMillis() > timeoutMillis) {
            return this.clientWithTimeout;
        }
        this.clientWithTimeout = this.client.newBuilder().readTimeout((long)(timeoutMillis + 1000), TimeUnit.MILLISECONDS).build();
        return this.clientWithTimeout;
    }

    private Request createRequest(BaseRequest request) {
        return new Request.Builder().url(this.baseUrl + request.getMethod()).post(this.createRequestBody(request)).build();
    }

    private RequestBody createRequestBody(BaseRequest<?, ?> request) {
        if (request.isMultipart()) {
            MediaType contentType = MediaType.parse((String)request.getContentType());
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (Map.Entry<String, Object> parameter : request.getParameters().entrySet()) {
                String name = parameter.getKey();
                Object value = parameter.getValue();
                if (value instanceof byte[]) {
                    builder.addFormDataPart(name, request.getFileName(), RequestBody.create((MediaType)contentType, (byte[])((byte[])value)));
                    continue;
                }
                if (value instanceof File) {
                    builder.addFormDataPart(name, request.getFileName(), RequestBody.create((MediaType)contentType, (File)((File)value)));
                    continue;
                }
                builder.addFormDataPart(name, String.valueOf(value));
            }
            return builder.build();
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> parameter : request.getParameters().entrySet()) {
            builder.add(parameter.getKey(), String.valueOf(parameter.getValue()));
        }
        return builder.build();
    }
}

