/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.MaskPosition;
import com.pengrad.telegrambot.model.Sticker;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class InputSticker
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String sticker;
    private String[] emoji_list;
    private MaskPosition mask_position;
    private String[] keywords;
    private Sticker.Format format;
    private transient String attachName;
    private transient Object attach;

    public InputSticker(Object sticker, Sticker.Format format, String[] emojiList) {
        this.format = format;
        this.emoji_list = emojiList;
        if (sticker instanceof String) {
            this.sticker = (String)sticker;
        } else {
            this.attach = sticker;
            this.attachName = AttachName.next();
            this.sticker = "attach://" + this.attachName;
        }
    }

    public String getAttachName() {
        return this.attachName;
    }

    public Object getAttachment() {
        return this.attach;
    }

    public InputSticker maskPosition(MaskPosition maskPosition) {
        this.mask_position = maskPosition;
        return this;
    }

    public InputSticker keywords(String[] keywords) {
        this.keywords = keywords;
        return this;
    }

    public InputSticker format(Sticker.Format format) {
        this.format = format;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputSticker)) {
            return false;
        }
        InputSticker that = (InputSticker)o;
        return Objects.equals(this.sticker, that.sticker) && Arrays.equals(this.emoji_list, that.emoji_list) && Objects.equals(this.mask_position, that.mask_position) && Arrays.equals(this.keywords, that.keywords) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.attachName, that.attachName) && Objects.equals(this.attach, that.attach);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.sticker, this.mask_position, this.format, this.attachName, this.attach});
        result = 31 * result + Arrays.hashCode(this.emoji_list);
        result = 31 * result + Arrays.hashCode(this.keywords);
        return result;
    }

    public String toString() {
        return "InputSticker{sticker='" + this.sticker + '\'' + ", emoji_list=" + Arrays.toString(this.emoji_list) + ", mask_position=" + this.mask_position + ", keywords=" + Arrays.toString(this.keywords) + ", format=" + (Object)((Object)this.format) + ", attachName='" + this.attachName + '\'' + ", attach=" + this.attach + '}';
    }
}

