/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.model.request.InlineKeyboardMarkup;
import com.pengrad.telegrambot.model.request.InputMedia;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.BaseResponse;
import com.pengrad.telegrambot.response.SendResponse;
import java.util.Map;

public class EditMessageMedia
extends BaseRequest<EditMessageMedia, BaseResponse> {
    private boolean isMultipart;
    private InputMedia<?> media;

    public EditMessageMedia(Object chatId, int messageId, InputMedia<?> media) {
        super(SendResponse.class);
        ((EditMessageMedia)this.add("chat_id", chatId)).add("message_id", messageId);
        this.addMedia(media);
    }

    public EditMessageMedia(String inlineMessageId, InputMedia<?> media) {
        super(BaseResponse.class);
        this.add("inline_message_id", inlineMessageId);
        this.addMedia(media);
    }

    private void addMedia(InputMedia<?> media) {
        this.media = media;
        this.add("media", media);
        Map<String, Object> attachments = media.getAttachments();
        if (attachments != null && attachments.size() > 0) {
            this.addAll(attachments);
            this.isMultipart = true;
        }
        if (media.inputFile() != null) {
            this.add(media.getInputFileId(), media.inputFile());
            this.isMultipart = true;
        }
    }

    public EditMessageMedia replyMarkup(InlineKeyboardMarkup replyMarkup) {
        return (EditMessageMedia)this.add("reply_markup", replyMarkup);
    }

    public EditMessageMedia businessConnectionId(String businessConnectionId) {
        return (EditMessageMedia)this.add("business_connection_id", businessConnectionId);
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }

    @Override
    public String getFileName() {
        return this.media.getFileName();
    }

    @Override
    public String getContentType() {
        return this.media.getContentType();
    }
}

