/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.utility;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.model.chatbackground.BackgroundFill;
import com.pengrad.telegrambot.model.chatbackground.BackgroundType;
import com.pengrad.telegrambot.model.chatboost.source.ChatBoostSource;
import com.pengrad.telegrambot.model.message.MaybeInaccessibleMessage;
import com.pengrad.telegrambot.model.message.origin.MessageOrigin;
import com.pengrad.telegrambot.model.paidmedia.PaidMedia;
import com.pengrad.telegrambot.model.reaction.ReactionType;
import com.pengrad.telegrambot.model.stars.partner.TransactionPartner;
import com.pengrad.telegrambot.model.stars.withdrawal.RevenueWithdrawalState;
import com.pengrad.telegrambot.utility.gson.BackgroundFillAdapter;
import com.pengrad.telegrambot.utility.gson.BackgroundTypeAdapter;
import com.pengrad.telegrambot.utility.gson.ChatBoostSourceTypeAdapter;
import com.pengrad.telegrambot.utility.gson.MaybeInaccessibleMessageTypeAdapter;
import com.pengrad.telegrambot.utility.gson.MessageOriginTypeAdapter;
import com.pengrad.telegrambot.utility.gson.PaidMediaTypeAdapter;
import com.pengrad.telegrambot.utility.gson.ReactionTypeAdapter;
import com.pengrad.telegrambot.utility.gson.RevenueWithdrawalStateTypeAdapter;
import com.pengrad.telegrambot.utility.gson.TransactionPartnerTypeAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BotUtils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ReactionType.class, (Object)new ReactionTypeAdapter()).registerTypeAdapter(MessageOrigin.class, (Object)new MessageOriginTypeAdapter()).registerTypeAdapter(ChatBoostSource.class, (Object)new ChatBoostSourceTypeAdapter()).registerTypeAdapter(MaybeInaccessibleMessage.class, (Object)new MaybeInaccessibleMessageTypeAdapter()).registerTypeAdapter(BackgroundType.class, (Object)new BackgroundTypeAdapter()).registerTypeAdapter(BackgroundFill.class, (Object)new BackgroundFillAdapter()).registerTypeAdapter(RevenueWithdrawalState.class, (Object)new RevenueWithdrawalStateTypeAdapter()).registerTypeAdapter(TransactionPartner.class, (Object)new TransactionPartnerTypeAdapter()).registerTypeAdapter(PaidMedia.class, (Object)new PaidMediaTypeAdapter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private BotUtils() {
    }

    public static Update parseUpdate(String update) {
        return (Update)GSON.fromJson(update, Update.class);
    }

    public static Update parseUpdate(Reader reader) {
        return (Update)GSON.fromJson(reader, Update.class);
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        int len = is.read(buffer);
        while (len != -1) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
        }
        return os.toByteArray();
    }

    public static <R> R fromJson(String jsonString, Class<R> resClass) {
        return (R)GSON.fromJson(jsonString, resClass);
    }

    public static String toJson(Object obj) {
        return GSON.toJson(obj);
    }
}

