/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.impl;

import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.Cancellable;
import com.pengrad.telegrambot.ExceptionHandler;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.TelegramException;
import com.pengrad.telegrambot.UpdatesListener;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.request.GetUpdates;
import com.pengrad.telegrambot.response.GetUpdatesResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdatesHandler {
    private TelegramBot bot;
    private UpdatesListener listener;
    private ExceptionHandler exceptionHandler;
    private Cancellable pendingRequest;
    private final long sleepTimeout;

    public UpdatesHandler(long sleepTimeout) {
        this.sleepTimeout = sleepTimeout;
    }

    public void start(TelegramBot bot, UpdatesListener listener, ExceptionHandler exceptionHandler, GetUpdates request) {
        this.bot = bot;
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        this.getUpdates(request);
    }

    public void stop() {
        this.bot = null;
        this.listener = null;
        this.exceptionHandler = null;
        if (this.pendingRequest != null) {
            this.pendingRequest.cancel();
            this.pendingRequest = null;
        }
    }

    private void getUpdates(GetUpdates request) {
        if (this.bot == null || this.listener == null) {
            return;
        }
        this.pendingRequest = this.bot.execute(request, new Callback<GetUpdates, GetUpdatesResponse>(){

            @Override
            public void onResponse(GetUpdates request, GetUpdatesResponse response) {
                int lastConfirmedUpdate;
                if (UpdatesHandler.this.listener == null) {
                    return;
                }
                if (!response.isOk() || response.updates() == null || response.updates().size() <= 0) {
                    if (!response.isOk()) {
                        if (UpdatesHandler.this.exceptionHandler != null) {
                            String message = "GetUpdates failed with error_code " + response.errorCode() + " " + response.description();
                            UpdatesHandler.this.exceptionHandler.onException(new TelegramException(message, response));
                        } else {
                            Logger.getGlobal().log(Level.INFO, "Update listener error for request " + request.toWebhookResponse() + " with response " + response.errorCode() + " " + response.description());
                        }
                    }
                    UpdatesHandler.this.sleep();
                    UpdatesHandler.this.getUpdates(request);
                    return;
                }
                List<Update> updates = response.updates();
                if (updates == null) {
                    updates = Collections.emptyList();
                }
                if ((lastConfirmedUpdate = UpdatesHandler.this.listener.process(updates)) != -2) {
                    int offset2 = lastConfirmedUpdate == -1 ? UpdatesHandler.this.lastUpdateId(updates) + 1 : lastConfirmedUpdate + 1;
                    request = request.offset(offset2);
                }
                UpdatesHandler.this.getUpdates(request);
            }

            @Override
            public void onFailure(GetUpdates request, IOException e) {
                if (e.getMessage().equals("Canceled")) {
                    return;
                }
                if (UpdatesHandler.this.exceptionHandler != null) {
                    UpdatesHandler.this.exceptionHandler.onException(new TelegramException(e));
                } else {
                    Logger.getGlobal().log(Level.INFO, "Update listener failure", e);
                }
                UpdatesHandler.this.sleep();
                UpdatesHandler.this.getUpdates(request);
            }
        });
    }

    private int lastUpdateId(List<Update> updates) {
        return updates.get(updates.size() - 1).updateId();
    }

    private void sleep() {
        if (this.sleepTimeout <= 0L) {
            return;
        }
        try {
            Thread.sleep(this.sleepTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

