package com.pichs.xsql.processor.util;


import com.pichs.xsql.annotation.SqlTable;
import com.pichs.xsql.processor.XSqlProcessor;
import com.pichs.xsql.processor.element.ClassElement;
import com.pichs.xsql.processor.element.FieldElement;
import com.pichs.xsql.processor.javawriter.JavaWriter;
import com.pichs.xsql.processor.kind.KindType;
import com.pichs.xsql.processor.kind.Modifys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class ClassGenerater {

    public static final String rootClassName = "XSqlProperties";
    public static final String rootPackageName = "com.pichs.xsql.property";
    private List<ClassElement> mClassElements;
    // 包名
    private String qualifiedName;

    public ClassGenerater(RoundEnvironment roundEnvironment) {
        mClassElements = new ArrayList<>();
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(SqlTable.class);

        if (elements != null) {
            for (Element element : elements) {
                if (element.getKind() == ElementKind.CLASS) {
                    TypeElement typeElement = (TypeElement) element;
                    if (typeElement.getAnnotation(SqlTable.class) == null) {
                        continue;
                    }
                    ClassElement classElement = new ClassElement(typeElement);
                    mClassElements.add(classElement);
                    XSqlProcessor.print("增加了一个ClassElement: " + element.getSimpleName());
                }
            }
        }
    }

    public void generate(JavaWriter jw) throws IOException {
        jw.emitPackage(rootPackageName);
        jw.beginType(rootClassName, KindType.CLASS, Modifys.getPublicFinal());
        jw.emitEmptyLine();
        XSqlProcessor.print("mClassElements: size :  " + mClassElements.size());
        for (ClassElement classElement : mClassElements) {
            jw.beginType(classElement.getClassName(), KindType.CLASS, Modifys.getPublicStaticFinal());
            jw.emitEmptyLine();
            List<FieldElement> fieldElements = classElement.getFieldElements();
            for (FieldElement fieldElement : fieldElements) {
                jw.emitField(KindType.STRING, fieldElement.getFieldName(), Modifys.getPublicStaticFinal(), Utils.formatString(fieldElement.getAnnFieldName()));
                jw.emitEmptyLine();
            }
            jw.endType();
            jw.emitEmptyLine();
        }
        jw.endType();
        jw.close();
    }

}
