/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;
import com.github.pires.obd.enums.AvailableCommandNames;

public class SpeedCommand
extends ObdCommand
implements SystemOfUnits {
    private int metricSpeed = 0;

    public SpeedCommand() {
        super("01 0D");
    }

    public SpeedCommand(SpeedCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.metricSpeed = (Integer)this.buffer.get(2);
    }

    public int getMetricSpeed() {
        return this.metricSpeed;
    }

    public float getImperialSpeed() {
        return this.getImperialUnit();
    }

    @Override
    public float getImperialUnit() {
        return Double.valueOf((double)this.metricSpeed * 0.621371192).floatValue();
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.2f%s", Float.valueOf(this.getImperialUnit()), this.getResultUnit()) : String.format("%d%s", this.getMetricSpeed(), this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return this.useImperialUnits ? String.valueOf(this.getImperialUnit()) : String.valueOf(this.getMetricSpeed());
    }

    @Override
    public String getResultUnit() {
        return this.useImperialUnits ? "mph" : "km/h";
    }

    @Override
    public String getName() {
        return AvailableCommandNames.SPEED.getValue();
    }
}

