/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.exceptions;

public class ResponseException
extends RuntimeException {
    private String message;
    private String response;
    private String command;
    private boolean matchRegex;

    protected ResponseException(String message) {
        this.message = message;
    }

    protected ResponseException(String message, boolean matchRegex) {
        this.message = message;
        this.matchRegex = matchRegex;
    }

    private static String clean(String s) {
        return s == null ? "" : s.replaceAll("\\s", "").toUpperCase();
    }

    public boolean isError(String response) {
        this.response = response;
        if (this.matchRegex) {
            return ResponseException.clean(response).matches(ResponseException.clean(this.message));
        }
        return ResponseException.clean(response).contains(ResponseException.clean(this.message));
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String getMessage() {
        return "Error running " + this.command + ", response: " + this.response;
    }
}

