/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class ModuleVoltageCommand
extends ObdCommand {
    private double voltage = 0.0;

    public ModuleVoltageCommand() {
        super("01 42");
    }

    public ModuleVoltageCommand(ModuleVoltageCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        int a = (Integer)this.buffer.get(2);
        int b = (Integer)this.buffer.get(3);
        this.voltage = (a * 256 + b) / 1000;
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.1f%s", this.voltage, this.getResultUnit());
    }

    @Override
    public String getResultUnit() {
        return "V";
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.voltage);
    }

    public double getVoltage() {
        return this.voltage;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.CONTROL_MODULE_VOLTAGE.getValue();
    }
}

