/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.PersistentCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class VinCommand
extends PersistentCommand {
    String vin = "";

    public VinCommand() {
        super("09 02");
    }

    public VinCommand(VinCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        String result = this.getResult();
        String workingData = result.contains(":") ? result.replaceAll(".:", "").substring(9) : result.replaceAll("49020.", "");
        String hexToString = this.convertHexToString(workingData);
        this.vin = hexToString.replaceAll("[\u0000-\u001f]", "");
    }

    @Override
    public String getFormattedResult() {
        return String.valueOf(this.vin);
    }

    @Override
    public String getName() {
        return AvailableCommandNames.VIN.getValue();
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.vin);
    }

    @Override
    protected void fillBuffer() {
    }

    public String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
        }
        return sb.toString();
    }
}

