/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.fuel;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class WidebandAirFuelRatioCommand
extends ObdCommand {
    private float wafr = 0.0f;

    public WidebandAirFuelRatioCommand() {
        super("01 34");
    }

    @Override
    protected void performCalculations() {
        float A = ((Integer)this.buffer.get(2)).intValue();
        float B = ((Integer)this.buffer.get(3)).intValue();
        this.wafr = (A * 256.0f + B) / 32768.0f * 14.7f;
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.2f", this.getWidebandAirFuelRatio()) + ":1 AFR";
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.getWidebandAirFuelRatio());
    }

    public double getWidebandAirFuelRatio() {
        return this.wafr;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.WIDEBAND_AIR_FUEL_RATIO.getValue();
    }
}

