/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.protocol;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;
import com.github.pires.obd.enums.ObdProtocols;

public class DescribeProtocolNumberCommand
extends ObdCommand {
    private ObdProtocols obdProtocol = ObdProtocols.AUTO;

    public DescribeProtocolNumberCommand() {
        super("AT DPN");
    }

    @Override
    protected void performCalculations() {
        ObdProtocols[] protocols;
        String result = this.getResult();
        char protocolNumber = result.length() == 2 ? result.charAt(1) : result.charAt(0);
        for (ObdProtocols protocol : protocols = ObdProtocols.values()) {
            if (protocol.getValue() != protocolNumber) continue;
            this.obdProtocol = protocol;
            break;
        }
    }

    @Override
    public String getFormattedResult() {
        return this.getResult();
    }

    @Override
    public String getCalculatedResult() {
        return this.obdProtocol.name();
    }

    @Override
    public String getName() {
        return AvailableCommandNames.DESCRIBE_PROTOCOL_NUMBER.getValue();
    }

    public ObdProtocols getObdProtocol() {
        return this.obdProtocol;
    }
}

