/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;
import com.github.pires.obd.enums.AvailableCommandNames;

public class DistanceTraveledWithMILOnObdCommand
extends ObdCommand
implements SystemOfUnits {
    private int km = 0;

    public DistanceTraveledWithMILOnObdCommand() {
        super("01 21");
    }

    public DistanceTraveledWithMILOnObdCommand(DistanceTraveledWithMILOnObdCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.km = (Integer)this.buffer.get(2) * 256 + (Integer)this.buffer.get(3);
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.2f%s", Float.valueOf(this.getImperialUnit()), "m") : String.format("%.2f%s", Float.valueOf(this.km), "km");
    }

    @Override
    public float getImperialUnit() {
        return Double.valueOf((double)this.km * 0.621371192).floatValue();
    }

    public int getKm() {
        return this.km;
    }

    public void setKm(int km) {
        this.km = km;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.DISTANCE_TRAVELED_MIL_ON.getValue();
    }
}

