/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.fuel;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SpeedObdCommand;
import com.github.pires.obd.commands.fuel.FuelConsumptionRateObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FuelEconomyObdCommand
extends ObdCommand {
    protected float kml = -1.0f;

    public FuelEconomyObdCommand() {
        super("");
    }

    @Override
    protected void performCalculations() {
    }

    @Override
    public void run(InputStream in, OutputStream out) throws IOException, InterruptedException {
        FuelConsumptionRateObdCommand fuelConsumptionCommand = new FuelConsumptionRateObdCommand();
        fuelConsumptionCommand.run(in, out);
        SpeedObdCommand speedCommand = new SpeedObdCommand();
        speedCommand.run(in, out);
        this.kml = (float)(100 / speedCommand.getMetricSpeed()) * fuelConsumptionCommand.getLitersPerHour();
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.1f %s", Float.valueOf(this.getMilesPerUKGallon()), this.getResultUnit()) : String.format("%.1f %s", Float.valueOf(this.kml), this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return this.useImperialUnits ? String.valueOf(this.getMilesPerUKGallon()) : String.valueOf(this.kml);
    }

    @Override
    public String getResultUnit() {
        return this.useImperialUnits ? "mpg" : "l/100km";
    }

    public float getLitersPer100Km() {
        return this.kml;
    }

    public float getMilesPerUSGallon() {
        return 235.2f / this.kml;
    }

    public float getMilesPerUKGallon() {
        return 282.5f / this.kml;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.FUEL_ECONOMY.getValue();
    }
}

