/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.enums;

import java.util.HashMap;
import java.util.Map;

public enum FuelTrim {
    SHORT_TERM_BANK_1(6, "Short Term Fuel Trim Bank 1"),
    LONG_TERM_BANK_1(7, "Long Term Fuel Trim Bank 1"),
    SHORT_TERM_BANK_2(8, "Short Term Fuel Trim Bank 2"),
    LONG_TERM_BANK_2(9, "Long Term Fuel Trim Bank 2");

    private static Map<Integer, FuelTrim> map;
    private final int value;
    private final String bank;

    private FuelTrim(int value, String bank) {
        this.value = value;
        this.bank = bank;
    }

    public static FuelTrim fromValue(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getBank() {
        return this.bank;
    }

    public final String buildObdCommand() {
        return new String("01 " + this.value);
    }

    static {
        map = new HashMap<Integer, FuelTrim>();
        for (FuelTrim error : FuelTrim.values()) {
            map.put(error.getValue(), error);
        }
    }
}

