/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommandRunner {
    private final Map<String, String> envVariable;
    private CommandResult commandResult;
    private String installationDir;
    private long commandTimeout;
    private String cwd;

    public CommandRunner(Map<String, String> env) {
        this.envVariable = env;
    }

    public CommandRunner(Map<String, String> env, String installationDir, long commandTimeout, String cwd) {
        this.envVariable = env;
        this.installationDir = installationDir;
        this.commandTimeout = commandTimeout;
        this.cwd = cwd;
    }

    public void runCommand(CommandRequest request) {
        String command = request.getFullCommand();
        if (StringUtils.isNotEmpty((CharSequence)this.installationDir)) {
            command = this.installationDir + command;
        }
        ArrayList listsResult = Lists.newArrayList();
        ArrayList listsError = Lists.newArrayList();
        long startTime = System.currentTimeMillis();
        try {
            String error;
            String line;
            Process start = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(start.getInputStream()));
            while ((line = reader.readLine()) != null) {
                listsResult.add(line);
            }
            reader = new BufferedReader(new InputStreamReader(start.getErrorStream()));
            while ((error = reader.readLine()) != null) {
                listsError.add(error);
            }
            int exitVal = start.waitFor();
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(exitVal, listsResult, listsError, timeTaken);
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(0, Collections.emptyList(), Lists.newArrayList((Object[])new String[]{e.getMessage()}), timeTaken);
        }
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public Map<String, String> getEnvVariable() {
        return this.envVariable;
    }
}

