/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter.appender;

import com.auto.framework.CustomTestRunner;
import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.http.HttpOpRequest;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.reporter.appender.TestConsoleAppender;
import com.auto.framework.reporter.appender.TestOutputStreamAppender;
import com.auto.framework.reporter.iface.IOutputFileStrategy;
import com.auto.framework.reporter.iface.TestReporterAppender;
import java.io.File;
import org.apache.log4j.Logger;

public class TestAppender
implements TestReporterAppender {
    protected static final Logger log = Logger.getLogger(TestAppender.class);
    private int iCommandNum = 0;
    private IOutputFileStrategy fileStrategy;

    public TestAppender(IOutputFileStrategy strategy) {
        this.fileStrategy = strategy;
    }

    public void incrementCommandNum() {
        ++this.iCommandNum;
    }

    @Override
    public void logMessage(String sMessage, boolean bError) {
        if (!bError) {
            log.info((Object)(this.generateCaller() + " - " + sMessage));
        } else {
            log.error((Object)(this.generateCaller() + " - " + sMessage + this.generateException()));
        }
    }

    @Override
    public void logMessage(String sMessage, Throwable t) {
        log.error((Object)(this.generateCaller() + " - " + sMessage), t);
    }

    protected String generateCaller() {
        try {
            StackTraceElement[] ste = new Exception().getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                String fileName = ste[i].getFileName().replace(".java", "");
                if (fileName.equals(TestReporter.class.getSimpleName()) || fileName.equals(TestAppender.class.getSimpleName()) || fileName.equals(TestOutputStreamAppender.class.getSimpleName()) || fileName.equals(TestConsoleAppender.class.getSimpleName()) || fileName.equals(CustomTestRunner.class.getSimpleName())) continue;
                return fileName + "." + ste[i].getMethodName() + "()";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    protected String generateException() {
        try {
            StackTraceElement[] ste = new Exception().getStackTrace();
            String sException = "";
            for (int i = 0; i < ste.length; ++i) {
                if (ste[i].getClassName().equals(TestReporter.class.getName())) continue;
                if (!ste[i].getClassName().startsWith("ct.air.")) break;
                sException = sException + "\n\tat " + ste[i].getClassName() + "." + ste[i].getMethodName() + "(" + ste[i].getFileName() + ":" + ste[i].getLineNumber() + ")";
            }
            return sException;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public void init() {
        this.resetCounters();
    }

    @Override
    public void traceExecution(CommandRequest cRequest, OpResult rResult) {
        String sCommandResultPath = this.dumpCommandResults(cRequest, rResult);
        this.logMessage("executed command " + this.iCommandNum + ": " + String.join((CharSequence)" ", cRequest.getCommand()), false);
        this.logMessage("result in: file://" + sCommandResultPath, false);
    }

    @Override
    public void traceExecution(HttpOpRequest request) {
        String sResultPath = this.dumpWebResults(request.getCommandName(), request.getUrl().toString(), request.getContent(), request.getStatusCode(), request.getOutput().toString());
        this.logMessage("executed request " + request.getUrl(), false);
        this.logMessage("result in file  file://" + sResultPath, false);
    }

    private synchronized String dumpCommandResults(CommandRequest cRequest, OpResult rResult) {
        ++this.iCommandNum;
        String sCommandFile = this.fileStrategy.getCommandFile(cRequest.getCommandName() + "_" + this.iCommandNum);
        String sFileName = TestReporter.getOutputDir() + File.separator + "operations" + File.separator + sCommandFile;
        this.writeToFile(cRequest, rResult, sFileName);
        return sFileName;
    }

    private synchronized String dumpWebResults(String sName, String sUrl, String sRequest, int iStatusCode, String bOutput) {
        ++this.iCommandNum;
        String sCommandFile = this.fileStrategy.getCommandFile(sName + "_" + this.iCommandNum);
        String sFileName = TestReporter.getOutputDir() + File.separator + "operations" + File.separator + sCommandFile;
        this.writeToFile(sRequest, iStatusCode, bOutput, sUrl, sFileName);
        return sFileName;
    }

    protected void writeToFile(String sRequest, int iStatusCode, String bOutput, String sUrl, String sFileName) {
    }

    protected void writeToFile(CommandRequest cRequest, OpResult rResult, String sFileName) {
    }

    private void resetCounters() {
        this.iCommandNum = 0;
    }

    protected int getCommandNum() {
        return this.iCommandNum;
    }

    protected synchronized void setCommandNum(int iCommandNum) {
        this.iCommandNum = iCommandNum;
    }
}

