/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter.appender;

import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.reporter.appender.CheckData;
import com.auto.framework.reporter.appender.TestAppender;
import com.auto.framework.reporter.iface.IOutputFileStrategy;

public class TestConsoleAppender
extends TestAppender {
    private boolean m_bStartOfLine = true;
    private static ThreadLocal<CheckData> m_checkData = new ThreadLocal();
    private CommandRequest m_lastRequest;
    private OpResult m_lastResult;
    private int m_CountMissed = 0;

    public TestConsoleAppender(IOutputFileStrategy strategy) {
        super(strategy);
    }

    public static CheckData getCheckData() {
        if (null == m_checkData.get()) {
            m_checkData.set(new CheckData());
        }
        return m_checkData.get();
    }

    @Override
    public void logMessage(String sMessage, boolean bError) {
        if (!this.m_bStartOfLine) {
            this.handlePreviousPrint();
        }
        if (!bError) {
            System.out.println(sMessage + " - called by " + this.generateCaller());
        } else {
            System.out.println(sMessage + " - called by " + this.generateCaller() + "\n" + this.generateException());
        }
        System.out.flush();
    }

    private void handlePreviousPrint() {
        System.out.print("\n");
        CommandRequest request = this.m_lastRequest;
        this.m_lastRequest = null;
        OpResult result = this.m_lastResult;
        this.m_lastResult = null;
        this.m_bStartOfLine = true;
        if (null != request) {
            int commandNum = this.getCommandNum();
            this.setCommandNum(commandNum - 1);
            super.traceExecution(request, result);
            this.setCommandNum(commandNum);
        }
    }

    @Override
    public void traceExecution(CommandRequest cRequest, OpResult rResult) {
        if (!TestConsoleAppender.getCheckData().isInCheck() || TestConsoleAppender.getCheckData().isReportingCheck()) {
            super.traceExecution(cRequest, rResult);
        } else {
            this.incrementCommandNum();
            System.out.print(".");
            this.m_bStartOfLine = false;
            this.m_lastRequest = cRequest;
            this.m_lastResult = rResult;
        }
    }

    @Override
    public void logMessage(String sMessage, Throwable t) {
        System.out.println(sMessage + " - called by " + this.generateCaller());
        t.printStackTrace();
        System.out.flush();
    }
}

