/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.console.progressbar;

import com.auto.framework.runner.console.progressbar.ProgressBarConsumer;
import com.auto.framework.runner.console.progressbar.Util;
import java.io.IOException;
import java.io.PrintStream;
import org.jline.terminal.Terminal;

public class ConsoleProgressBarConsumer
implements ProgressBarConsumer {
    private static int consoleRightMargin = 2;
    private final PrintStream out;
    private Terminal terminal = Util.getTerminal();

    ConsoleProgressBarConsumer() {
        this(System.err);
    }

    ConsoleProgressBarConsumer(PrintStream out) {
        this.out = out;
    }

    @Override
    public int getMaxProgressLength() {
        return Util.getTerminalWidth(this.terminal) - consoleRightMargin;
    }

    @Override
    public void accept(String str) {
        this.out.print('\r');
        this.out.print(str);
    }

    @Override
    public void close() {
        this.out.println();
        this.out.flush();
        try {
            this.terminal.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

