/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.console.progressbar;

import com.auto.framework.runner.console.progressbar.ProgressBarRenderer;
import com.auto.framework.runner.console.progressbar.ProgressBarStyle;
import com.auto.framework.runner.console.progressbar.ProgressState;
import com.auto.framework.runner.console.progressbar.Util;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;

public class DefaultProgressBarRenderer
implements ProgressBarRenderer {
    private ProgressBarStyle style;
    private String unitName;
    private long unitSize;
    private boolean isSpeedShown;
    private DecimalFormat speedFormat;

    DefaultProgressBarRenderer(ProgressBarStyle style, String unitName, long unitSize, boolean isSpeedShown, DecimalFormat speedFormat) {
        this.style = style;
        this.unitName = unitName;
        this.unitSize = unitSize;
        this.isSpeedShown = isSpeedShown;
        this.speedFormat = speedFormat;
    }

    private int progressIntegralPart(ProgressState progress, int length) {
        return (int)(progress.getNormalizedProgress() * (double)length);
    }

    private int progressFractionalPart(ProgressState progress, int length) {
        double p = progress.getNormalizedProgress() * (double)length;
        double fraction = (p - Math.floor(p)) * (double)this.style.fractionSymbols.length();
        return (int)Math.floor(fraction);
    }

    private String eta(ProgressState progress, Duration elapsed) {
        if (progress.max <= 0L || progress.indefinite) {
            return "?";
        }
        if (progress.current == 0L) {
            return "?";
        }
        return Util.formatDuration(elapsed.dividedBy(progress.current).multipliedBy(progress.max - progress.current));
    }

    private String percentage(ProgressState progress) {
        String res = progress.max <= 0L || progress.indefinite ? "? %" : String.valueOf((int)Math.floor(100.0 * (double)progress.current / (double)progress.max)) + "%";
        return res;
    }

    private String ratio(ProgressState progress) {
        String m = progress.indefinite ? "?" : String.valueOf(progress.max / this.unitSize);
        String c = String.valueOf(progress.current / this.unitSize);
        return Util.repeat(' ', m.length() - c.length()) + c + "/" + m + this.unitName;
    }

    private String speed(ProgressState progress, Duration elapsed) {
        if (elapsed.getSeconds() == 0L) {
            return "?" + this.unitName + "/s";
        }
        double speed = (double)progress.current / (double)elapsed.getSeconds();
        double speedWithUnit = speed / (double)this.unitSize;
        return this.speedFormat.format(speedWithUnit) + this.unitName + "/s";
    }

    @Override
    public String render(ProgressState progress, int maxLength) {
        Instant currTime = Instant.now();
        Duration elapsed = Duration.between(progress.startTime, currTime);
        String taskName = StringUtils.isEmpty((CharSequence)progress.task) ? "" : progress.task + " ";
        String prefix = taskName + this.percentage(progress) + " " + this.style.leftBracket;
        int maxSuffixLength = Math.max(maxLength - prefix.length(), 0);
        String speedString = this.isSpeedShown ? this.speed(progress, elapsed) : "";
        String suffix = this.style.rightBracket + " " + this.ratio(progress) + " (" + Util.formatDuration(elapsed) + " / " + this.eta(progress, elapsed) + ") " + speedString + progress.extraMessage;
        if (suffix.length() > maxSuffixLength) {
            suffix = suffix.substring(0, maxSuffixLength);
        }
        int length = maxLength - prefix.length() - suffix.length();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (progress.indefinite) {
            int pos = (int)(progress.current % (long)length);
            sb.append(Util.repeat(this.style.space, pos));
            sb.append(this.style.block);
            sb.append(Util.repeat(this.style.space, length - pos - 1));
        } else {
            sb.append(Util.repeat(this.style.block, this.progressIntegralPart(progress, length)));
            if (progress.current < progress.max) {
                sb.append(this.style.fractionSymbols.charAt(this.progressFractionalPart(progress, length)));
                sb.append(Util.repeat(this.style.space, length - this.progressIntegralPart(progress, length) - 1));
            }
        }
        sb.append(suffix);
        return sb.toString();
    }
}

