/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.console.progressbar;

import com.auto.framework.runner.console.progressbar.ConsoleProgressBarConsumer;
import com.auto.framework.runner.console.progressbar.DefaultProgressBarRenderer;
import com.auto.framework.runner.console.progressbar.ProgressBarBuilder;
import com.auto.framework.runner.console.progressbar.ProgressBarConsumer;
import com.auto.framework.runner.console.progressbar.ProgressBarRenderer;
import com.auto.framework.runner.console.progressbar.ProgressBarStyle;
import com.auto.framework.runner.console.progressbar.ProgressState;
import com.auto.framework.runner.console.progressbar.ProgressThread;
import com.auto.framework.runner.console.progressbar.Util;
import com.auto.framework.runner.console.progressbar.wrapped.ProgressBarWrappedInputStream;
import com.auto.framework.runner.console.progressbar.wrapped.ProgressBarWrappedIterable;
import com.auto.framework.runner.console.progressbar.wrapped.ProgressBarWrappedIterator;
import com.auto.framework.runner.console.progressbar.wrapped.ProgressBarWrappedSpliterator;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ProgressBar
implements AutoCloseable {
    private ProgressState progress;
    private ProgressThread target;
    private Thread thread;

    public ProgressBar(String task, long initialMax) {
        this(task, initialMax, 1000, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L, false, null);
    }

    public ProgressBar(String task, long initialMax, ProgressBarStyle style) {
        this(task, initialMax, 1000, System.err, style, "", 1L, false, null);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis) {
        this(task, initialMax, updateIntervalMillis, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L, false, null);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style, String unitName, long unitSize) {
        this(task, initialMax, updateIntervalMillis, os, style, unitName, unitSize, false, null);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style, String unitName, long unitSize, boolean showSpeed) {
        this(task, initialMax, updateIntervalMillis, os, style, unitName, unitSize, showSpeed, null);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style, String unitName, long unitSize, boolean showSpeed, DecimalFormat speedFormat) {
        this(task, initialMax, updateIntervalMillis, new DefaultProgressBarRenderer(style, unitName, unitSize, showSpeed, speedFormat), new ConsoleProgressBarConsumer(os));
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, ProgressBarRenderer renderer, ProgressBarConsumer consumer) {
        this.progress = new ProgressState(task, initialMax);
        this.target = new ProgressThread(this.progress, renderer, updateIntervalMillis, consumer);
        this.thread = new Thread((Runnable)this.target, this.getClass().getName());
        this.progress.startTime = Instant.now();
        this.thread.start();
    }

    public ProgressBar stepBy(long n) {
        this.progress.stepBy(n);
        return this;
    }

    public ProgressBar stepTo(long n) {
        this.progress.stepTo(n);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long n) {
        if (n < 0L) {
            this.progress.setAsIndefinite();
        } else {
            this.progress.setAsDefinite();
            this.progress.maxHint(n);
        }
        return this;
    }

    @Override
    public void close() {
        this.thread.interrupt();
        try {
            this.thread.join();
            this.target.closeConsumer();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ProgressBar setExtraMessage(String msg) {
        this.progress.setExtraMessage(msg);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTask() {
        return this.progress.getTask();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, String task) {
        return ProgressBar.wrap(it, new ProgressBarBuilder().setTaskName(task).setInitialMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedIterator<T>(it, pbb.build());
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, String task) {
        return ProgressBar.wrap(ts, new ProgressBarBuilder().setTaskName(task));
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, ProgressBarBuilder pbb) {
        long size = ts.spliterator().getExactSizeIfKnown();
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedIterable<T>(ts, pbb);
    }

    public static InputStream wrap(InputStream is, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task).setInitialMax(Util.getInputStreamSize(is));
        return ProgressBar.wrap(is, pbb);
    }

    public static InputStream wrap(InputStream is, ProgressBarBuilder pbb) {
        long size = Util.getInputStreamSize(is);
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedInputStream(is, pbb.build());
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(sp, pbb);
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, ProgressBarBuilder pbb) {
        long size = sp.getExactSizeIfKnown();
        if (size != -1L) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedSpliterator<T>(sp, pbb.build());
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(stream, pbb);
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, ProgressBarBuilder pbb) {
        Spliterator<T> sp = ProgressBar.wrap(stream.spliterator(), pbb);
        return StreamSupport.stream(sp, stream.isParallel());
    }
}

