/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework;

import com.auto.framework.CustomTestRunner;
import com.auto.framework.auto.AutoConf;
import com.auto.framework.env.TestEnvironment;
import com.auto.framework.iface.ITestCase;
import com.auto.framework.iface.ITestComponent;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.reporter.data.TestDataReporter;
import com.auto.framework.rules.error.HaltOnErrorRule;
import com.auto.framework.rules.logging.KeepLogRule;
import com.auto.framework.rules.mock.MockRequestResponseRule;
import com.auto.framework.rules.tags.TagsRule;
import com.auto.framework.utils.FileUtil;
import com.auto.framework.utils.JsonUtil;
import com.auto.framework.utils.TestBaseDirectory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;

@RunWith(value=CustomTestRunner.class)
public abstract class AbstractTestCase
implements ITestCase {
    public static int MAX_RUN_TIME_MIN = 10;
    public static final String BASE_DIR_ROOT = "/tmp" + File.separator + "auto" + File.separator;
    private final String currentApplication;
    private String baseDir;
    private boolean running = true;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public Timeout testGlobalTimeout = new Timeout((long)MAX_RUN_TIME_MIN, TimeUnit.MINUTES);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public MockRequestResponseRule mockRequestResponseRule = new MockRequestResponseRule();
    @Rule
    public HaltOnErrorRule haltOnErrorRule = new HaltOnErrorRule();
    @Rule
    public KeepLogRule keepLogRule = new KeepLogRule();
    @Rule
    public TagsRule tagsRule = new TagsRule();
    protected AutoConf config;

    protected AbstractTestCase(String aApplication) {
        this.currentApplication = aApplication;
    }

    @Before
    public final void init() {
        this.decideOnBaseDir();
        this.initConfiguration();
        this.initTestEnvironment();
        this.initReporter();
        this.initComponents();
        this.startComponents();
        this.cleanComponents(true);
        this.prepareTags();
        this.prepareComponentsForExecution();
        TestReporter.TRACE(this.prepareTick() + "Startup sequence finished" + this.prepareTick());
        TestEnvironment.setReadyTime();
    }

    private void prepareTags() {
        TestDataReporter.addData("tags", this.tagsRule.getTags(), true);
    }

    private String prepareTick() {
        StringBuilder tick = new StringBuilder(" ");
        for (int i = 0; i < 20; ++i) {
            tick.append("\u2714").append(" ");
        }
        return tick.toString();
    }

    protected void initConfiguration() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/auto.json");
            this.config = (AutoConf)JsonUtil.getObjectMapper().readValue(in, AutoConf.class);
            if (StringUtils.isEmpty((CharSequence)this.config.getResourcePath())) {
                TestReporter.FATAL("config file doesn't have resource path");
            }
            if (!FileUtil.exist(this.config.getResourcePath())) {
                TestReporter.TRACE("resource path doesn't exists, creating folder with path name " + this.config.getResourcePath());
                new File(this.config.getResourcePath()).mkdirs();
            }
            if (CollectionUtils.isEmpty(this.config.getApplications()) || this.config.getApplications().stream().noneMatch(a -> this.getCurrentApplication().equals(a.getName()))) {
                TestReporter.FATAL("config file doesn't have application : " + this.getCurrentApplication());
            }
        }
        catch (Exception e) {
            TestReporter.FATAL(e);
        }
    }

    protected void initTestEnvironment() {
        TestEnvironment.init(this, this.getSandBoxDir(), this.tmpFolder);
        TestEnvironment.setShouldKeepLog(this.keepLogRule.keepLog());
        TestEnvironment.setHaltOnError(this.haltOnErrorRule.isHaltOnError());
        TestEnvironment.setConfig(this.config);
        TestEnvironment.setCurrentApplication(this.getCurrentApplication());
    }

    protected String getCurrentApplication() {
        return this.currentApplication;
    }

    protected AutoConf.Application getCurrentApplicationConfig() {
        return this.config.getApplications().stream().filter(a -> this.getCurrentApplication().equals(a.getName())).findFirst().get();
    }

    protected void prepareComponentsForExecution() {
        this.onAllComponents(com -> {
            if (com.isRunning()) {
                com.prepare();
            }
        });
    }

    private void initReporter() {
        TestReporter.init(this);
        TestReporter.start();
        TestDataReporter.init();
    }

    protected abstract void initComponents();

    public AutoConf getConfig() {
        return this.config;
    }

    @Override
    public String getTestName() {
        return this.testName.getMethodName();
    }

    @Override
    public String getTestGroup() {
        return this.getClass().getName();
    }

    @Override
    public String getSandBoxDir() {
        return this.baseDir;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public final void tearDown() {
        try {
            this.tearDownComponents();
        }
        finally {
            this.finishReporter();
        }
    }

    private void decideOnBaseDir() {
        this.baseDir = TestBaseDirectory.generate(this);
        FileUtil.delete(this.baseDir);
        FileUtil.createLinkSilent(BASE_DIR_ROOT + "current", this.baseDir);
    }

    protected void tearDownComponents() {
        try {
            this.setRunning(false);
            TestReporter.TRACE("tearDownComponents");
            TestReporter.TRACE(this.prepareTick() + "Test completed starting teardown" + this.prepareTick());
            this.tearDownComponentsSpecific();
            TestReporter.TRACE("Cleaning On Test Finish");
            this.clean();
            this.stopComponents();
            this.checkExceptions();
            this.checkMemoryLeaks();
        }
        finally {
            this.reportTestExecutionInfo();
        }
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    protected void reportTestExecutionInfo() {
    }

    private void checkMemoryLeaks() {
    }

    protected void tearDownComponentsSpecific() {
    }

    private void checkExceptions() {
    }

    private void clean() {
        this.cleanComponents(false);
    }

    protected void stopComponents() {
        this.onAllComponents(comp -> {
            if (comp.isRunning()) {
                comp.stop();
            }
        });
    }

    protected void startComponents() {
        this.onAllComponents(comp -> {
            long lStart = System.currentTimeMillis();
            assert (comp != null);
            comp.start();
            long lFinish = System.currentTimeMillis();
            this.recordStartupTime((ITestComponent)comp, lFinish - lStart);
        });
    }

    protected void recordStartupTime(ITestComponent comp, long l) {
        TestReporter.TRACE("Startup Time for " + comp.getComponentName() + " in host " + comp.getHost() + " : " + l);
    }

    protected void cleanComponents(boolean bForce) {
        this.onAllComponents(comp -> {
            assert (comp != null);
            comp.clean(bForce);
        }, comp -> {
            assert (comp != null);
            return comp.getCleanOrder();
        });
    }

    protected void onAllComponents(Consumer<ITestComponent> fFunction) {
        this.onAllComponents(fFunction, null);
    }

    protected void onAllComponents(Consumer<ITestComponent> fFunction, Function<ITestComponent, Integer> orderFunc) {
        List<ITestComponent> lstValidComponents = this.getTestComponents().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (null != orderFunc) {
            TreeMap<Integer, List<ITestComponent>> treeMap = this.sortTestComponentsAccordingToOrder(lstValidComponents, orderFunc);
            for (Integer order : treeMap.navigableKeySet()) {
                treeMap.get(order).forEach(fFunction);
            }
        } else {
            lstValidComponents.forEach(fFunction);
        }
    }

    private TreeMap<Integer, List<ITestComponent>> sortTestComponentsAccordingToOrder(List<? extends ITestComponent> lstComponents, Function<ITestComponent, Integer> orderFunc) {
        TreeMap<Integer, List<ITestComponent>> treeMap = new TreeMap<Integer, List<ITestComponent>>();
        for (ITestComponent iTestComponent : lstComponents) {
            int order = null == orderFunc ? 0 : orderFunc.apply(iTestComponent);
            List<ITestComponent> lst = treeMap.get(order);
            if (CollectionUtils.isEmpty(lst)) {
                lst = new ArrayList<ITestComponent>();
                treeMap.put(order, lst);
            }
            lst.add(iTestComponent);
        }
        return treeMap;
    }

    public String getResourcePath() {
        return this.config.getResourcePath();
    }

    private void finishReporter() {
        TestReporter.finish();
    }

    protected AutoConf.Application getConfigForApp(String appName) {
        if (CollectionUtils.isEmpty(this.config.getApplications()) || this.config.getApplications().stream().noneMatch(a -> this.getCurrentApplication().equals(appName))) {
            TestReporter.FATAL("config file doesn't have application : " + appName);
        }
        return this.config.getApplications().stream().filter(a -> a.getName().equals(appName)).findAny().get();
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
    }
}

