/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.runner.CommandProcess;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CommandRunner {
    private final Map<String, String> envVariable;
    private CommandResult commandResult;
    private String installationDir;
    private long commandTimeout = 60L;
    private String cwd;

    public CommandRunner(Map<String, String> env) {
        this.envVariable = env;
    }

    public CommandRunner(Map<String, String> env, String installationDir, long commandTimeout, String cwd) {
        this.envVariable = env;
        this.installationDir = installationDir;
        this.commandTimeout = commandTimeout;
        this.cwd = cwd;
    }

    public void runCommand(CommandRequest commandRequest) {
        long startTime = System.currentTimeMillis();
        String[] command = commandRequest.getCommand();
        if (StringUtils.isNotEmpty((CharSequence)this.installationDir)) {
            command = this.addFirst(command, this.installationDir);
        }
        File wd = null;
        if (StringUtils.isNotEmpty((CharSequence)this.cwd)) {
            wd = new File(this.cwd);
        }
        String[] environment = null;
        if (MapUtils.isNotEmpty(this.envVariable)) {
            environment = (String[])this.envVariable.entrySet().stream().map(entry -> (String)entry.getKey() + "+" + (String)entry.getValue()).toArray(String[]::new);
        }
        try {
            ByteArrayOutputStream ourStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            FutureTask<Integer> task = new FutureTask<Integer>(new CommandProcess(command, environment, wd, ourStream, errorStream));
            Thread t = new Thread(task);
            t.start();
            Integer integer = task.get(this.commandTimeout, TimeUnit.SECONDS);
            Iterable iterableOut = Splitter.on((String)System.getProperty("line.separator")).split((CharSequence)new String(ourStream.toByteArray()));
            Iterable iterableErr = Splitter.on((String)System.getProperty("line.separator")).split((CharSequence)new String(ourStream.toByteArray()));
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(integer, Lists.newArrayList((Iterable)iterableOut), Lists.newArrayList((Iterable)iterableErr), timeTaken);
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(-1, Collections.emptyList(), Lists.newArrayList((Object[])new String[]{e.getMessage()}), timeTaken);
        }
    }

    private String[] addFirst(String[] command, String element) {
        String[] arr = new String[command.length + 1];
        arr[0] = element;
        System.arraycopy(command, 0, arr, 1, command.length);
        return arr;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public Map<String, String> getEnvVariable() {
        return this.envVariable;
    }
}

