/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter.appender;

import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.reporter.appender.CheckData;
import com.auto.framework.reporter.appender.TestAppender;
import com.auto.framework.reporter.iface.IOutputFileStrategy;

public class TestConsoleAppender
extends TestAppender {
    private boolean startOfLine = true;
    private static ThreadLocal<CheckData> checkData = new ThreadLocal();
    private CommandRequest lastRequest;
    private OpResult lastResult;

    public TestConsoleAppender(IOutputFileStrategy strategy) {
        super(strategy);
    }

    public static CheckData getCheckData() {
        if (null == checkData.get()) {
            checkData.set(new CheckData());
        }
        return checkData.get();
    }

    @Override
    public void logMessage(String sMessage, boolean bError) {
        if (!this.startOfLine) {
            this.handlePreviousPrint();
        }
        if (!bError) {
            System.out.println(sMessage + " - called by " + this.generateCaller());
        } else {
            System.out.println(sMessage + " - called by " + this.generateCaller() + "\n" + this.generateException());
        }
        System.out.flush();
    }

    private void handlePreviousPrint() {
        System.out.print("\n");
        CommandRequest request = this.lastRequest;
        this.lastRequest = null;
        OpResult result = this.lastResult;
        this.lastResult = null;
        this.startOfLine = true;
        if (null != request) {
            int commandNum = this.getCommandNum();
            this.setCommandNum(commandNum - 1);
            super.traceExecution(request, result);
            this.setCommandNum(commandNum);
        }
    }

    @Override
    public void traceExecution(CommandRequest cRequest, OpResult rResult) {
        if (!TestConsoleAppender.getCheckData().isInCheck() || TestConsoleAppender.getCheckData().isReportingCheck()) {
            super.traceExecution(cRequest, rResult);
        } else {
            this.incrementCommandNum();
            System.out.print(".");
            this.startOfLine = false;
            this.lastRequest = cRequest;
            this.lastResult = rResult;
        }
    }

    @Override
    public void logMessage(String sMessage, Throwable t) {
        System.out.println(sMessage + " - called by " + this.generateCaller());
        t.printStackTrace();
        System.out.flush();
    }
}

